const path = require('path');
const CopyPlugin = require('copy-webpack-plugin');

module.exports = {
	entry: './src/index.ts',
	mode: 'production',
	module: {
		rules: [
			{
				test: /\.tsx?$/,
				use: 'ts-loader',
				exclude: /node_modules/,
			}
		],
	},
	plugins: [
		new CopyPlugin({
			patterns: [
				{ context: 'src/', from: '*.css' },
				{ context: 'src/', from: '*.html' },
				{ context: 'src/', from: '*.ttf' },
				{ context: 'src/', from: '**/*.png' }
			]
		})
	],
	resolve: {
		extensions: ['.tsx', '.ts', '.js'],
	},
	output: {
		filename: 'bundle.js',
		path: path.resolve(__dirname, 'dist'),
	},
};
