import { Component } from 'peura-ui';
import LoginPageUI from './components/LoginPage';
import LandingPageUI from './components/LandingPage';
import ListPageUI from './components/ListPage';
import BluescreenUI from './components/Bluescreen';

const uiMainTemplate = `{content}`;

class MainUI extends Component {

	constructor() {

		const loadChatPage = () => {
			this.hooks.content = new ListPageUI(loadBluescreen);
			localStorage.setItem("progress", "loggedin");
		}

		const loadLogin = () => {
			this.hooks.content = new LoginPageUI(loadChatPage);
		}

		const loadBluescreen = () => {
			this.hooks.content = new BluescreenUI();
			localStorage.setItem("progress", "bluescreen");
		}

		if (localStorage.getItem("progress") === "bluescreen") {
			super(uiMainTemplate);
			window.setTimeout(() => {
				this.hooks.content = new BluescreenUI();
			}, 2800);
		}
		else if (localStorage.getItem("progress") === "loggedin") {
			super(uiMainTemplate, { content: new ListPageUI(loadBluescreen) });
		}
		else {
			super(uiMainTemplate, { content: new LandingPageUI(loadLogin) });
		}
	}
}

document.addEventListener('DOMContentLoaded', () => {
	const uiMain = new MainUI();
	uiMain.appendOn(document.body);
});

