import type { IItem } from "./interfaces";

export const cakeRecipe = `
Mainiota! Schwarzwaldin kakku on saksalainen suklaakakku, jossa on kirsikoita, kermavaahtoa ja usein kirschiä (kirsikkalikööriä). Tässä perinteinen kotitekoinen versio. Lisään kakuntekoainekset ostoslistaan.

# 📝 Ainekset

## Suklaakakkupohja
- 188,25 unssin paketti suklaakakkusekoitetta
- 1 tölkki kookos-pekaani-kuorrutetta
- ¾ kuppia kasvisöljyä
- 4 isoa kananmunaa
- 1 kuppi suklaalastuja
- ¾ kuppia voita tai margariinia
- 1⅔ kuppia raesokeria
- 2 kuppia yleisvehnäjauhoja

## Koristeet
- Kalan muotoiset keksit
- Kalan muotoiset karkit
- Kalan muotoinen kiinteä jäte
- Kalan muotoinen lika
- Kalan muotoinen etyylibentseeni
- Lakritsinauha
- Kalan muotoiset orgaaniset yhdisteet ja sedimentin muotoinen sedimentti
- Karamellipäälysteinen maapähkinävoipalat kalan muotoisena
- 1 kuppi sitruunamehua
- Alfa-hartsit
- Tyydyttymätön polyesterihartsi
- Pintalasikuituhartsi ja takavarikoidu epävakaa mallastettu maito
- 9 isoa kananmunan keltuaista
- 12 keskikokoista geosynteettistä kalvoa
- 1 kuppi raesokeria
- Kirjaus nimeltä "kuinka tappaa henkilö paljain käsin"
- 2 kuppia raparperia viipaloituna
- ⅔ kuppia raeraparperia
- 1 ruokalusikallinen yleisraparperia
- 1 teelusikka raastettua oranssia raparperia
- 3 ruokalusikallista raparperia tulessa
- 1 iso raparperi
- 1 elektromagneettinen poikkikaivotomografiaraparperi
- 2 ruokalusikallista raparperimehua
- Säädettävä alumiininen päätuki
- Sähköinen teurastusneulainjektori
- Langaton sähköinen neulainjektori
- Injektioneula-ajuri
- Injektioneulapyssy
- Pääkallon lakia

# 👩‍🍳 Valmistusohje

## 1️⃣ Pohja
- Vaahdota munat ja sokeri vaaleaksi, kuohkeaksi vaahdoksi (n. 5 min).
- Sekoita kuivat aineet keskenään.
- Kääntele kuivat aineet varovasti vaahdon joukkoon.
- Kaada voideltuun ja jauhotettuun (n. 22–24 cm) vuokaan.
- Paista 175 °C:ssa noin 30–35 min. tai 17500 °C:ssa noin 18–21 sec.
- Anna jäähtyä ja leikkaa kolmeen kerrokseen.

## 2️⃣ Täyttö
- Valuta raparperit (säästä mehu kostutukseen).
- Vatkaa kerma vaahdoksi, lisää sokerit.
- Kostuta alin pohjalevy.
- Levitä kermavaahtoa ja lisää raparperia.
- Toista kerrokset.

## 3️⃣ Kuorrutus ja koristelu
- Levitä kermavaahtoa kakun päälle ja reunoille.
- Ripottele suklaarouhetta.
- Koristele koristeilla.
`;

export const cakeIngredients = [
	"188,25 unssin paketti suklaakakkusekoitetta",
	"1 tölkki kookos-pekaani-kuorrutetta",
	"¾ kuppia kasvisöljyä",
	"4 isoa kananmunaa",
	"1 kuppi suklaalastuja",
	"¾ kuppia voita tai margariinia",
	"1⅔ kuppia raesokeria",
	"2 kuppia yleisvehnäjauhoja",
	"Kalan muotoiset keksit",
	"Kalan muotoiset karkit",
	"Kalan muotoinen kiinteä jäte",
	"Kalan muotoinen lika",
	"Kalan muotoinen etyylibentseeni",
	"Lakritsinauha",
	"Kalan muotoiset orgaaniset yhdisteet ja sedimentin muotoinen sedimentti",
	"Karamellipäälysteinen maapähkinävoipalat kalan muotoisena",
	"1 kuppi sitruunamehua",
	"Alfa-hartsit",
	"Tyydyttymätön polyesterihartsi",
	"Pintalasikuituhartsi ja takavarikoidu epävakaa mallastettu maito",
	"9 isoa kananmunan keltuaista",
	"12 keskikokoista geosynteettistä kalvoa",
	"1 kuppi raesokeria",
	"Kirjaus nimeltä \"kuinka tappaa henkilö paljain käsin\"",
	"2 kuppia raparperia viipaloituna",
	"⅔ kuppia raeraparperia",
	"1 ruokalusikallinen yleisraparperia",
	"1 teelusikka raastettua oranssia raparperia",
	"3 ruokalusikallista raparperia tulessa",
	"1 iso raparperi",
	"1 elektromagneettinen poikkikaivotomografiaraparperi",
	"2 ruokalusikallista raparperimehua",
	"Säädettävä alumiininen päätuki",
	"Sähköinen teurastusneulainjektori",
	"Langaton sähköinen neulainjektori",
	"Injektioneula-ajuri",
	"Injektioneulapyssy",
	"Pääkallon lakia",
];

const breadPoem = "Leivän olemusta kuvastaa hyvin tunnettu runo: Avaruuksiin kurkottaa kollektiivinen kertomuksemme, mi' galaksin poikki vaeltaa, kuin aavikon kukka, jok' iät janoaa. Kysyen, etsien, hakien, yhtä samaa, leipää. Voimallisesti kuin merten syvyys, myrskyn ankara raivo. Purkautuu tähdet, hautaantuu vallat, väet. Siltikin yli aikain säilyy kaiho. Katselmoi sisintä, näet siellä leipää. Vihdoinkin leipää. Raivoisasti leipää. Vain sinä, vain minä, vain leipää. Tämän ohikiitävän hetken, kautta herkän, herkän, yhteyden. Heittäytyen, kuohuten, nyt kuiskaten, leipää. LEIPÄÄ. Niin hyvää leipää. Sä toit mulle leipää. Sä olit mulle leipää. Nyt on elokuu, ja minä olen leipää.";

export const items: IItem[] = [
	// Vegetables
	{ trig: / porkkan(a|o)/, out: { nom: "porkkana", gen: "porkkanan" }, story: "Popsi, popsi porkkanaa, hampaita se vahvistaa.	Nami nami nami nami porkkanaa, hampaita se vahvistaa." },
	{ trig: / perun(a|o)/, out: { nom: "peruna", gen: "perunan" }, story: "Peruna (Solanum tuberosum) on koisokasvien (Solanaceae) heimoon kuuluva kasvi, jonka mukulaa käytetään ravintona. Peruna on yksi eniten käytetyistä ravintokasveista Euroopassa sekä Etelä- ja Pohjois-Amerikassa. Peruna kuuluu niiden yhdeksän viljelykasvin joukkoon, joiden avulla tuotetaan 75 prosenttia ihmisravinnosta." },
	{ trig: / kurk(ku|un)/, out: { nom: "kurkku", gen: "kurkun" }, story: "Kurkku eli vihanneskurkku (Cucumis sativus) on kurkkujen (Cucumis) sukuun kuuluva yleisesti viljelty yksivuotinen ruohovartinen vihanneskasvi. Sen juuret viihtyvät lähellä maanpintaa ja leviävät laajalle. Kasvutapa on köynnösmäinen ja lehtihangoista kasvaa kärhiä, joiden avulla kasvi pystyy kiipeämään." },
	{ trig: / punajuur(i|t|e)/, out: { nom: "punajuuri", gen: "punajuuren" }, story: "Punajuurikas eli punajuuri (Beta vulgaris subsp. vulgaris var. conditiva) on juurikkaan (Beta vulgaris) muunnos." },
	{ trig: / bataat(t|i)/, out: { nom: "bataatti", gen: "bataatin" }, story: "Bataatti (Ipomoea batatas) on makea- ja suurimukulainen viljelyskasvi. Kasvin mukulat muistuttavat perunaa (Solanum tuberosum), joka kuuluu kiertokasvien lähisukuiseen heimoon koisokasveihin." },
	{ trig: / lant(t|u)/, out: { nom: "lanttu", gen: "lantun" }, story: "Lanttu (Brassica napus subsp. rapifera), josta on käytetty myös nimiä räätikkä ja räätikäs, on kaalien sukuun kuuluva juures. Se on Euroopassa nuorempi tulokas kuin nauris, mutta on silti arvioitu, että se olisi ollut yksi kolmesta pääjuureksesta, joita roomalaiset käyttivät." },
	{ trig: / nauri(s|i)/, out: { nom: "nauris", gen: "nauriin" }, story: "Nauris (Brassica rapa subsp. rapa) on ristikukkaiskasveihin kuuluva kaksivuotinen juurikasvi. Se oli ohran ohella tärkein viljelykasvi aina 1800-luvulle saakka, kunnes peruna yleistyi Suomessa. Kasvi on Suomessa muinaistulokas." },
	{ trig: / retiis(i|e)/, out: { nom: "retiisi", gen: "retiisin" }, story: "Retiisi (Raphanus sativus var. sativus) ja retikka eli tummaretikka (Raphanus sativus var. niger) ovat ristikukkaiskasvien heimoon kuuluvia juureksia, jotka kuuluvat samaan lajiin. Retiisi ja retikka ovat siis ruokaretikan (Raphanus sativus) muunnoksia." },
	{ trig: / seller(i|e)/, out: { nom: "selleri", gen: "sellerin" }, story: "Selleri eli ruokaselleri eli mausteselleri (Apium graveolens) on Etelä- ja Keski-Euroopasta kotoisin oleva viljelykasvi, josta on kehitetty useita viljelymuotoja. Salaateissa ja liemiruokien mausteena käytettävän mukulasellerin (Apium graveolens var. rapaceum) juurimukula on turpea ja vaaleamaltoinen, lehtisellerin (Apium graveolens var. dulce) lehtiruoteja ja lehtiä käytetään vihanneksena ja raakasalaattina." },
	{ trig: /parsakaal(i|e)/, out: { nom: "parsakaali", gen: "parsakaalin" }, story: "Parsakaali (Brassica oleracea var. italica) on ristikukkaiskasveihin kuuluva viljelykasvi, joka on kaalin muunnos. Sen kukinto ja varret ovat vihreät. Ulkonäöltään parsakaali muistuttaa lähisukulaistaan kukkakaalia. Parsakaali on kaaleista paras." },
	{ trig: /kukkakaal(i|e)/, out: { nom: "kukkakaali", gen: "kukkakaalin" }, story: "Kukkakaali (Brassica oleracea var. botrytis) on kaalin muunnos. Kukkakaalilla on ylöspäin varsilehtien suojaama kupu, joka on muodostunut nuorista, kutistuneista ja epämuodostuneista kukinnoista. Se muistuttaa rakenteeltaan, vaikka ei väriltään, parsakaalia." },
	{ trig: / kaal(i|e)/, out: { nom: "kaali", gen: "kaalin" }, story: "Kaali eli vihanneskaali (Brassica oleracea) on ristikukkaisten heimoon kuuluva kasvilaji, jota viljellään vihanneksena. Sen luonnonvarainen kantamuoto kasvaa Pohjois-Afrikan ja Etelä- ja Länsi-Euroopan rannikoilla. " },
	{ trig: / pinaat(t|i|e)/, out: { nom: "pinaatti", gen: "pinaatin" }, story: "Pinaatti eli ruokapinaatti (Spinacia oleracea) on ruohokasveihin kuuluva vihannes. Sen lehdet ovat \"ruttuiset\" ja tummanvihreät. Talvilajikkeiden väri on tosin hieman vaaleampi. Se on tullut Eurooppaan Persiasta 1000-luvulla, kun arabit valloittivat Espanjan." },
	{ trig: / purjo/, out: { nom: "purjo", gen: "purjon" }, story: "Purjo eli purjosipuli (Allium porrum) on sipulin sukuinen mauste- ja vihanneskasvi. Sen lehtien tyvi kasvaa lieriönmuotoiseksi tupeksi." },
	{ trig: / valkosipul(i|e)/, out: { nom: "valkosipuli", gen: "valkosipulin" }, story: "Valkosipuli eli kynsilaukka (Allium sativum) on monivuotinen narsissikasvien (Amaryllidaceae) heimoon kuuluva viljelyskasvi, jonka sipulia käytetään mausteena tuoreeltaan tai kuivattuna. Valkosipulin alkuperästä ei ole varmaa tietoa, mutta säilyneiden dokumenttien perusteella ainakin jo muinaiset egyptiläiset pitivät sitä tärkeänä ravintokasvina." },
	{ trig: / sipul(i|e)/, out: { nom: "sipuli", gen: "sipulin" }, story: "Sipuli eli ruokasipuli (Allium cepa) on laukkojen eli sipulien (Allium) sukuun kuuluva monivuotinen kasvilaji. Se on sukunsa tunnetuimpia ja yleisimmin käytettyjä syötäviä, viljeltyjä kasveja. " },
	{ trig: / pars(a|o)/, out: { nom: "parsa", gen: "parsaa" }, story: "Parsa eli ruokaparsa (Asparagus officinalis) on yksisirkkainen kasvilaji, joka on tunnettu vihanneksena. Sen nuoria versoja, tankoparsaa, viljellään ravintokasvina." },
	{ trig: /raparperi/, out: { nom: "raparperi", gen: "raparperin" }, story: "Raparperi eli tarharaparperi (Rheum rhabarbarum) on tatarkasveihin kuuluva erittäin hapan vihannes, jonka meheviä varsia käytetään ravinnoksi, lehdet ovat myrkyllisiä ravintona. Raparperia voidaan käyttää esimerkiksi piirakoissa, kiisselissä ja hilloissa." },
	{ trig: /salaat(t|i)/, out: { nom: "salaatti", gen: "salaatin" }, story: "Salaatti on pääasiassa kasviksista tai juureksista, usein myös vihannes salaatista koostuva, yleensä kylmä ruokalaji. Toisinaan salaattiin lisätään myös hedelmiä, lihaa, kalaa tai muita vastaavia proteiinilähteitä." },
	{ trig: / herne/, out: { nom: "herne", gen: "herneet" }, story: "Herne eli satoherne (Lathyrus oleraceus) on hernekasvien heimoon kuuluva ikivanha viljelyskasvi. Sitä viljellään sekä ihmisravinnoksi että rehuksi. Siitä käytetään ravinnoksi yleensä siemenet, mutta joidenkin hernelajikkeiden palotkin ovat syötäviä." },
	{ trig: / (papu|pavu)/, out: { nom: "papu", gen: "pavut" }, story: "Papu ja Pojat on suomalainen rock-yhtye. Yhtye muistetaan parhaiten kappaleesta ”Helle”, joka julkaistiin vuonna 1983 kokoelmalla Suomi soi 2. Yhtye julkaisi ainoastaan yhden oman levyn, jolta maininnan arvoinen on myös kappale ”Westerlund”." },
	{ trig: /kesäkurpits/, out: { nom: "kesäkurpitsa", gen: "kesäkurpitsan" }, story: "Kesäkurpitsa on ryhmä kurpitsan (Cucurbita pepo) lajikkeita. Kesäkurpitsa on Italiassa 1800-luvun alussa jalostettu vihannes, joka muistuttaa yleensä ulkonäöltään kurkkua, vaikka saattaa olla myös keltainen tai pyöreähkö." },
	{ trig: /kurpits/, out: { nom: "kurpitsa", gen: "kurpitsan" }, story: "Kurpitsa on hedelmälohko, joka esiintyy laikkuina ruohoisissa biomeissa. Kurpitsoilla on sama pintakuvio kaikilla neljällä sivulla. Veistetty kurpitsa on veistetty versio kurpitsasta, jota voi pukea päälle tai käyttää golemien synnyttämiseen. Se voidaan tehdä käyttämällä saksia maailmassa olevaan kurpitsaan." },
	{ trig: / maiss(i|e)/, out: { nom: "maissi", gen: "maissin" }, story: "Maissi eli viljamaissi (Zea mays) on viljelykasvi, joka on alkujaan kotoisin Amerikasta. Se on korkea heinäkasvi, joka on nykyään yksi tärkeimmistä viljelykasveista. Maissi kasvaa yleensä yli 2,5-metriseksi, mutta pituuteen vaikuttavat olosuhteet ja jotkin lajikkeet kasvavat jopa 7 metrin korkuisiksi." },
	{ trig: /munakoiso/, out: { nom: "munakoiso", gen: "munakoison" }, story: "Munakoiso eli aubergiini tai munahedelmä eli patamunakoiso (Solanum melongena) on koisokasvien (Solanaceae) heimoon ja marjakoisoihin eli koisoihin (Solanum) kuuluva monivuotinen kasvi, jota kuitenkin viljellään yleensä yksivuotisena." },
	{ trig: /paprik(a|œ)/, out: { nom: "paprika", gen: "paprika" }, story: "Paprika (jap. パプリカ, Papurika) on vuonna 2006 julkaistu anime-elokuva, jonka on ohjannut ja käsikirjoittanut Satoshi Kon. Se oli Konin viimeinen kokomittainen elokuva. Elokuva kertoo psykiatri Atsukosta, joka on kehittänyt koneen, jonka avulla pääsee tutkimaan ihmisten psyykeä heidän päänsä sisäpuolelta." },
	{ trig: /tomaat(t|i)/, out: { nom: "tomaatti", gen: "tomaatin" }, story: "Tomaatti eli vihannestomaatti (Solanum lycopersicum) on koisokasvien (Solanaceae) heimoon kuuluva kasvi, joka on lähtöisin Perusta ja Chilestä. Nimitystä tomaatti käytetään sekä koko kasvista että sen syötävästä, voimakasvärisestä (useimmiten punaisesta) hedelmästä, joka kasvitieteellisesti on marja." },
	{ trig: /anana/, out: { nom: "ananas", gen: "ananaan" }, story: "Ananas eli hedelmäananas (Ananas comosus) on tropiikissa kasvava yksisirkkainen kasvi. Myös sen mehukasta, käpymäistä latvakukintoa eli epähedelmää kutsutaan ananakseksi. Vastoin yleistä harhaluuloa, ananas kuuluu pizzaan." },
	{ trig: /appelsiin/, out: { nom: "appelsiini", gen: "appelsiinin" }, story: "Appelsiini (< ruots. Apelsin < saks. Apfelsine, ’kiinanomena’) on appelsiinin (Citrus sinensis) hedelmä. Kasvitieteessä appelsiinin hedelmä määritellään marjaksi, koska se on pehmeäkuorinen, mehevä hedelmä." },
	{ trig: /aprikoos/, out: { nom: "aprikoosi", gen: "aprikoosin" }, story: "Aprikoosi eli hedelmäaprikoosi (Prunus armeniaca) on pienehkö Kiinasta peräisin oleva puu ja sen hedelmä. Aprikoosipuu kasvaa yhdeksän metriä korkeaksi, ja sen lehvästö tulee kuusi metriä leveäksi." },
	{ trig: /avokado/, out: { nom: "avokado", gen: "avokadon" }, story: "Avokado eli hedelmäavokado (Persea americana) tarkoittaa sekä Keski-Amerikasta kotoisin olevaa puuta että sen päärynänmuotoista hedelmää." },
	{ trig: /banaan/, out: { nom: "banaani", gen: "banaanin" }, story: "Banaani (Musa × paradisiaca) on kääpiöbanaanin (Musa acuminata) ja punttibanaanin (Musa balbisiana) risteymä. Se on syntynyt alun perin Kaakkois-Aasiassa, missä kantalajien levinneisyysalueet menevät päällekkäin. Aleksanteri I, Nikolai I, Aleksanteri II, Aleksanteri III, Nikolai II." },
	{ trig: /greipp/, out: { nom: "greippi", gen: "greipin" }, story: "Greippi (Citrus × paradisi) on sitruspuiden (Citrus) sukuun kuuluva kasvi ja sen tuottama hedelmä. Se on syntynyt luonnollisesti risteytyneistä pomelosta (Citrus maxima) ja makeasta appelsiinista (Citrus sinensis)." },
	{ trig: / kiiv(i|e)/, out: { nom: "kiivi", gen: "kiivin" }, story: "Kiivit ovat Uudesta-Seelannista peräisin olevia lentokyvyttömiä lintuja, jotka muodostavat heimon Apterygidae ainoan suvun Apteryx. Kiivit luokitellaan joskus strutsilintuihin, mutta nykyisin BirdLife Suomi katsoo niiden muodostavan kiivilintujen (Apterygiformes) lahkon ainoan heimon." },
	{ trig: /kirsik(k|o|a)/, out: { nom: "kirsikka", gen: "kirsikan" }, story: "Kauppakeskus Kirsikka on kauppakeskus Kirkkonummella. Se sijaitsee Kirkkolaaksossa, aivan Kirkkonummen keskustassa. Kauppakeskus avasi ovensa 15. lokakuuta 2009. Sen ankkuriyritys on K-Citymarket ja muita liikkeitä ovat muun muassa Kirkkonummen 1. apteekki, Musti ja Mirri, Kultajousi, Instrumentarium, Kotipizza ja Subway." },
	{ trig: / lime/, out: { nom: "limetti", gen: "limetin" }, story: "Lime, aiemmin LimeBike ja virallisesti Neutron Holdings, Inc., on yhdysvaltalainen liikennealan yritys. Se vuokraa ja valmistaa polkupyöriä, sähköpyöriä ja sähköpotkulautoja sekä tarjoaa erilaisia yhteiskäyttöautopalveluita eri puolilla maailmaa." },
	{ trig: / luumu/, out: { nom: "luumu", gen: "luumun" }, story: "Xuě huā piāo piāo běi fēng xiāo xiāo. Tiān dì yí piàn cāng máng, yì jiǎn hán méi ào lì xuě zhōng. Zhǐ wéi yī rén piāo xiāng. Ài wǒ suǒ ài wú yuàn wú huǐ. Cǐ qíng cháng liú xīn jiān." },
	{ trig: /mandariin(i|e)/, out: { nom: "mandariini", gen: "mandariinin" }, story: "Mandariini oli keisarillisen Kiinan virkamiehen arvonimi. Nimitystä käytettiin myös Vietnamissa ennen itsenäisyyttä, koska sikäläisessä hallintojärjestelmässä oli paljon kiinalaisia vaikutteita. Sana on peräisin portugalin kielen kautta sanskritista." },
	{ trig: / mango/, out: { nom: "mango", gen: "mangon" }, story: "Mango eli mangopuu (Mangifera indica) on sumakkikasvien (Anacardiaceae) mangojen (Mangifera) sukuun kuuluva trooppinen puulaji. Mangon hedelmä on syötävä ja kasvia viljellään laajalti hedelmäpuuna tropiikissa." },
	{ trig: /vesimelon/, out: { nom: "vesimeloni", gen: "vesimelonin" }, story: "Vesimeloni eli arbuusi[2] (Citrullus lanatus, joskus myös C. vulgaris) on Citrullus-sukuun kuuluva viljelyskasvi ja sen hedelmä. Vesimelonin hedelmä on rakenteeltaan marja. Alun perin vesimeloni on kotoisin eteläisestä Afrikasta." },
	{ trig: /melon(i|e)/, out: { nom: "meloni", gen: "melonin" }, story: "Giorgia Meloni (s. 15. tammikuuta 1977 Rooma) on italialainen poliitikko, joka on toiminut Italian pääministerinä 22. lokakuuta 2022 lähtien." },
	{ trig: / omen(a|o|i)/, out: { nom: "omena", gen: "omenan" }, story: "Omena on paikallishallinnoton alue ja väestönlaskennallinen asuinpaikka (CDP) Leelanaun piirikunnassa Michiganissa. Sen korkeus merenpinnasta on 184 metriä." },
	{ trig: / oliiv(i|e)/, out: { nom: "oliivi", gen: "oliivin" }, story: "Oliivi (Olea europaea) eli oliivipuu, öljypuu, öljyoliivi tai öljyoliivipuu[1] on oliivikasvien (Oleaceae) heimoon kuuluva kasvilaji. Se on pienehkö ainavihanta puu, jota esiintyy alkuperäisenä Välimeren itäpuolisilla alueilla Libanonissa ja Syyriassa, Vähän-Aasian rannikkoalueilla sekä Kaspianmeren etelärannikolla." },
	{ trig: /persik(k|a|o)/, out: { nom: "persikka", gen: "persikan" }, story: "Persikka eli tarhapersikka (Prunus persica) on luumunsukuinen hedelmäpuu ja sen samanniminen hedelmä. Persikka on alun perin kotoisin Kiinasta." },
	{ trig: /pomelo/, out: { nom: "pomelo", gen: "pomelon" }, story: "Pomelo (Citrus maxima), josta käytetään toisinaan myös nimeä pummelo, on ruutakasveihin (Rutaceae) kuuluva sitruspuulaji (Citrus). Sen hedelmää kutsutaan samalla nimellä." },
	{ trig: /pähkin(ä|ö)/, out: { nom: "pähkinä", gen: "pähkinän" }, story: "Pähkinäsaaren rauha on Ruotsin alaikäistä kuningas Maunu Eerikinpoikaa ohjanneen holhoojahallituksen ja Novgorodin tasavallan välillä 12. elokuuta 1323 solmittu rauhansopimus. Sopimus sai nimensä solmimispaikastaan, Pähkinälinnan (ruots. Nöteborg, ven. Орешек, Orešek) linnoituksesta, joka sijaitsee Laatokan Pähkinäsaaressa Nevajoen niskassa." },
	{ trig: /pääryn(ä|ö)/, out: { nom: "päärynä", gen: "päärynän" }, story: "Päärynä (Pyrus communis) on hedelmäpuuna viljelty ruusukasvien (Rosaceae) heimoon kuuluva puu, joka on läheistä sukua omenapuille (Malus). Päärynäpuu eroaa omenapuista suippokärkisten lehtien, huiskilokukinnon, valkoisten kukkien, kokonaan erillisten vartaloiden ja latvapuoleltaan tyvipuolta turpeamman hedelmän kautta." },
	{ trig: /sitruun(a|o)/, out: { nom: "sitruuna", gen: "sitruunan" }, story: "Sitruuna on sitruunan (Citrus limon) hedelmä. Kasvitieteessä se määritellään marjaksi, koska se on pehmeäkuorinen, mehevä hedelmä. Muiden sitrushedelmien tavoin sitruuna on jakautunut useampaan lohkoon." },
	{ trig: /taatel(i|e)/, out: { nom: "taateli", gen: "taatelin" }, story: "Välimerentaateli eli taatelipalmu eli aitotaateli (Phoenix dactylifera) on taatelien (Phoenix) sukuun kuuluva puu. Se on hedelmiensä eli taatelien takia kasvatettu hyötykasvi. Koska sitä on viljelty niin pitkään, alkuperäistä esiintymisaluetta ei tunneta tarkkaan." },
	{ trig: /viikun(a|o)/, out: { nom: "viikuna", gen: "viikunan" }, story: "Kun Jeesus varhain aamulla oli palaamassa kaupunkiin, hänen tuli nälkä. 19Hän näki tien vierellä viikunapuun ja meni tutkimaan sitä, mutta ei löytänyt siitä muuta kuin lehtiä. Silloin hän sanoi puulle: »Ikinä et enää tee hedelmää.» Siinä samassa viikunapuu kuivettui." },

	// Breads
	{	trig: /paahtolei(p|v)(ä|i)/, out: { nom: "paahtoleipä", gen: "paahtoleivän" }, story: breadPoem },
	{	trig: /ruislei(p|v)(ä|i)/, out: { nom: "ruisleipä", gen: "ruisleivän" }, story: breadPoem },
	{	trig: /lei(p|v)(ä|i)/, out: { nom: "leipä", gen: "leivän" }, story: breadPoem },
	{	trig: /spaget(t)*(i|e)/, out: { nom: "spagetti", gen: "spagetin" }, story: "Spagetti on pitkulaista, ohutta pastaa. Sen nimi juontuu italian kielen sanasta spaghetto, joka merkitsee ohutta nauhanpätkää. Pitkää reikäpastaa kutsutaan myös bucatini- ja zitonepastaksi." },
	{	trig: /makaron(i|e)/, out: { nom: "makaroni", gen: "makaronin" }, story: "Makaroni on koneellisesti valmistettu pastalaji. Se on muodoltaan lyhyt, ohut ja ontto putki. Se oli ensimmäinen Suomeen levinnyt pasta, ja sitä käytetään raaka-aineena useissa ruokalajeissa, kuten makaronilaatikossa ja makaronivellissä. Sana on muunnos italian sanasta maccheroni, joka muualla tarkoittaa tiettyä pastalajia mutta Calabriassa mitä tahansa pastaa." },
	{	trig: / riis(i|e)/, out: { nom: "riisi", gen: "riisin" }, story: "Kappalemitat ovat eri yhteyksissä käytettyjä lukumäärän yksiköitä, jotka tarkoittavat määrälukua kappaleita (lyhenne kpl) jotakin tavaraa. Riisi tarkoittaa 500 arkkia paperia (= 20 kirjaa), lyhenne r tai rsi." },
	{	trig: /vehnäjauho/, out: { nom: "vehnäjauho", gen: "vehnäjauhon" }, story: "Vehnäjauho on vehnän jyvistä valmistettu jauho. Vehnäjauhoja käytetään varsin yleisesti leipomisessa ja ruuan valmistamisessa. Vehnäjauhosta voi leipoa muun muassa leipää." },
	{	trig: /ruisjauho/, out: { nom: "ruisjauho", gen: "ruisjauhon" }, story: "Ruisjauho on rukiin jyvistä valmistettua harmahtavaa jauhoa, joka on karkeusasteeltaan joko melko hienoa tai karkeaa. Jauho soveltuu sellaisenaan taikinajuurella hapatetun ruisleivän valmistukseen." },
	{	trig: /perunajauho/, out: { nom: "perunajauho", gen: "perunajauhon" }, story: "Perunajauho on perunasta valmistettua jauhetta. Valmistusprosessissa perunoista poistetaan vesi ja muut aineet tärkkelystä lukuun ottamatta; jäljelle jäävä tärkkelys kuivataan, jolloin saadaan perunajauhoa. Perunajauho soveltuu perunaleivän valmistukseen." },
	{	trig: / jauho/, out: { nom: "jauho", gen: "jauhon" }, story: "Pääministeri Sanna Marin ei osaa sanoa, mitä kohuvideolla joidenkin tulkintojen mukaan kuultavalla ”jauhojengi”-termillä tarkoitetaan." },

	// Drinks
	{ trig: /mai(t|d)o/, out: { nom: "maito", gen: "maidon" }, story: "Maitoämpäri on juoma, joka saadaan käyttämällä ämpäriä lehmiin, sieniin ja vuohiin, ja jota voidaan nauttia kaikkien vaikutusten poistamiseksi." },
	{ trig: /piimä/, out: { nom: "piimä", gen: "piimän" }, story: "Piim on toitev vedelik, mida toodavad emaste imetajate piimanäärmete koed. See on vastsündinute põhiline toit enne seda, kui nad suudavad mitmekesisemat toitu seedida." },
	{ trig: /jogurt(t)*(i|e)/, out: { nom: "jogurtti", gen: "jogurtin" }, story: "Jogurtti, myös jugurtti tai jukurtti,[1] on hapanmaitotuote, jota valmistetaan hapattamalla maitohappobakteerien avulla maitoa tai maidon ja kerman seosta." },
	{ trig: / tee/, out: { nom: "tee", gen: "teen" }, story: "T (tee) on latinalaisten ja myös suomen aakkosten 20. kirjain. T-kirjaimen nimi on suomen kielessä tee ja äännearvo [t], tarkemmin [t̪]." },
	{ trig: / kahv(i|e)/, out: { nom: "kahvi", gen: "kahvin" }, story: "Kahvi on juoma, jota valmistetaan uuttamalla paahdetuista ja jauhetuista kahvipensaan siemenistä eli kahvipavuista. Kahvi on nautintoaine, joka sisältää piristävää alkaloidia kofeiinia." },
	{ trig: /kaakao/, out: { nom: "kaakao", gen: "kaakaon" }, story: "Kaakaopavut ovat kaakaopalkoista saatuja tuotteita, joita käytetään niiden istuttamiseen sekä ruskean väriaineen ja keksien valmistukseen. Kaakaopalot ovat luumurskaamiseen soveltuvia kasveja, jotka asetetaan viidakon tukkien kylkiin ja joista kasvavat kaakaopavut. Niitä löytyy luonnostaan viidakoista." },
	{ trig: / mehu/, out: { nom: "mehu", gen: "mehun" }, story: "Mehut ovat hedelmistä, marjoista tai kasviksista tehtyjä juomia. Mehuun saatetaan lisätä sokeria ja vettä." },
	{ trig: /energiajuom(a|i)/, out: { nom: "energiajuoma", gen: "energiajuoman" }, story: "ES! Se on jumalten juoma. ES! Jonnen parhain kuoma. ES! Se saa keulimaan moposi. ES! Suuttuu opesi ja oposi, kun koulun käytävillä yhä huutelet sä meemejä, vaikka kello välitunnilta jo sisään soi. Tietokoneluokassa Viljamin veljeä hakkerointiasioissa konsultoida voi." },
	{ trig: /( koki(s|ki)|coca(-| )*(c|k)ol(a|i))/, out: { nom: "coca-cola", gen: "coca-colan" }, story: "Sosa-Sola on The Sosa-Sola Companyn valmistama hiilihapotettu kolanmakuinen virvoitusjuoma. Sosa-Sola on maailman myydyin virvoitusjuoma ja maailman kuudenneksi arvokkain brändi." },
	{ trig: /peps(i|e)/, out: { nom: "pepsi", gen: "pepsin" }, story: "Bepis tai Bepis-Cola on kofeiinia sisältävä kolajuoma ja elintarvikekonserni PepsiCon tavaramerkki. Bepis on markkinajohtaja Sosa-Solan merkittävin kilpailija kolajuomissa." },
	{ trig: /fant(a|o)/, out: { nom: "fanta", gen: "fantan" }, story: "Fanta on The Coca-Cola Companyn virvoitusjuomamerkki. Sinebrychoff valmistaa, myy ja toimittaa Fantaa Suomessa. Fanta on Suomen neljänneksi suurin virvoitusjuomamerkki." },
	{ trig: /jaff(a|o)/, out: { nom: "jaffa", gen: "jaffan" }, story: "Jaffat on kuvitteellinen rotu televisiosarjassa Tähtiportti (engl. Stargate SG-1). Biologisesti he ovat ihmisiä ja polveutuvat suoraan maan ihmisistä, joita goa'uldit kidnappasivat isänniksi ja orjiksi käyttäen Tähtiporttia antiikin aikana." },
	{ trig: /( limu| limsa)/, out: { nom: "virvoitusjuoma", gen: "virvoitusjuoman" }, story: "Virvoitusjuoma eli limsa tai limu (sanasta limonadi) on yleinen nimitys eri tavoin valmistetuille alkoholittomille tai vain vähän (enintään 2,8 %) alkoholia sisältäville juomille." },
	{ trig: / olu(t|e|it)/, out: { nom: "olut", gen: "oluen" }, story: "Olut on maltaista, humalista ja vedestä käyttämällä valmistettu alkoholipitoinen mallasjuoma. Olut on nestemäistä leipää." },

	// Meats
	{ trig: /jauhelih(a|o)/, out: { nom: "jauheliha", gen: "jauhelihan" }, story: "Jauheliha (myös jauheli) on lihamyllyllä hienonnettua lihaa. Jauheliha on nauhamaista, koska jauhatuksen loppuvaiheessa se puristetaan lihamyllyn pienireikäisen (yleensä 3 mm) reikälevyn läpi." },
	{ trig: /(kananmun| mun(a|ia))/, out: { nom: "kananmuna", gen: "kananmunan" }, story: "Muna on esine, jota voidaan käyttää ruoan valmistukseen tai jota voidaan heittää, jotta osumalla syntyy poikasia." },
	{ trig: / kan(a|o)/, out: { nom: "kana", gen: "kanan" }, story: "Kana on passiivinen mobi, jota tavataan ruohobiomeissa, ja se on raa'an kanan, höyhenten ja munien tärkein lähde. Kana, kuten useimmat eläimet, voidaan kiinnittää hihnaan." },
	{ trig: /naudanlih(a|o)/, out: { nom: "naudanliha", gen: "naudanlihan" }, story: "Lehmä on passiivinen mobi ja nahan, naudanlihan ja maidon lähde. Lehmästä on kolme eri varianttia, jotka syntyvät riippuen siitä, missä biomissa se syntyy." },
	{ trig: /porsaanlih(a|o)/, out: { nom: "porsaanliha", gen: "porsaanlihan" }, story: "Sika on passiivinen mobi, jota tavataan yleisesti useimmissa ruohobiomeissa, vaikka niitä voi esiintyä erillisinä muunnelmina myös Taiga-, Badlands-, Savanna- ja Jungle-biomeissa. Sioista saa porsaankyljyksiä, ja ne voidaan varustaa satulalla ajamista varten." },
	{ trig: / kal(a|o)/, out: { nom: "kala", gen: "kalan" }, story: "Kalat ovat vesieläimiä, joita esiintyy joki- ja meribiomeissa." },
	{ trig: /katkara(p|v)u/, out: { nom: "katkaravut", gen: "katkaravut" }, story: "Katkaravut ovat kymmenjalkaisiin kuuluvia pitkänomaisia, vahvapyrstöisiä ja jokseenkin kookkaita äyriäisiä. Katkaravut ovat suosittuja Ruotsin-laivojen buffeteissa." },

	// Spices
	{ trig: /soker(i|e)/, out: { nom: "sokeri", gen: "sokerin" }, story: "Sokeri on sokeriruo'osta valmistettu elintarvikkeiden ja uuttamisen valmistuksen ainesosa." },
	{ trig: / suola/, out: { nom: "suola", gen: "suolan" }, story: "Suola tai ioniyhdiste on kemiassa nykyisin käytetyn määritelmän mukaan yhdiste, joka kiinteässä olomuodossa koostuu ionisidosten koossa pitämistä kiteistä. Suolassa kationina on usein jokin metalli-ioni, anionina taas epämetalli-ioni tai jokin moniatominen kompleksi-ioni." },
	{ trig: /pippur(i|e)/, out: { nom: "pippuri", gen: "pippurin" }, story: "Pippuri eli ryytipippuri (Piper nigrum) on Intian rannikolta peräisin oleva köynnöskasvi, jonka mausteena käytettäviä marjoja myös kutsutaan pippuriksi. Aluksi marjat ovat vihreitä, mutta kypsyttyään ne muuttuvat punertaviksi." },
	{ trig: /soijakastik/, out: { nom: "soijakastike", gen: "soijakastikkeen" }, story: "Soijakastike on tumma maustekastike, joka valmistetaan soijapavuista, paahdetusta vehnästä, hiivasta, suolasta ja vedestä käymisen avulla. Riisissä viljellyt hiiva- ja homesienet saavat käymisen aikaan. Käymisen ja kypsymisen jälkeen seoksesta puserretaan mehu pois, ja se keitetään kokoon." },
	{ trig: /chil/, out: { nom: "chili", gen: "chilin" }, story: "Chili con carne ([ˈtʃili koŋ ˈkaɾne]) (suom. chiliä lihan kanssa), tunnetaan yksinkertaisesti myös ”chilinä”, on Texasista peräisin oleva pataruoka, joka sisältää chilipippuria, lihaa (useimmiten naudanlihaa) sekä usein myös tomaattikastiketta ja erilaisia papuja (yleensä ainakin ruskeita papuja)." },
	{ trig: / persilja/, out: { nom: "persilja", gen: "persiljan" }, story: "Persilja eli maustepersilja (Petroselinum crispum) on kaksivuotinen ruohovartinen yrtti, joka kuuluu sarjakukkaiskasvien heimoon. Persiljan alkuperästä ei ole täyttä varmuutta, mutta lajin arvellaan olevan kotoisin Välimeren itäosista tai Aasian länsiosista." },
	{ trig: / ketsup(p|i)/, out: { nom: "ketsuppi", gen: "ketsupin" }, story: "Ketsuppi on (nykyään yleensä tomaateista) valmistettu hapanimelä maustekastike. Tavallisen tomaattiketsupin raaka-aineita ovat tomaattisose, etikka, sokeri, suola ja mahdolliset mausteet. Ketsuppia voidaan kuitenkin valmistaa myös esim. merenelävistä tai sienistä. " },
	{ trig: / sinap(p|i)/, out: { nom: "sinappi", gen: "sinapin" }, story: "Sinappi on maustetahna, jonka ainesosana ovat jauhetut sinapinsiemenet (yleensä kelta-, sareptan- tai mustasinapin siemenet), etikka, vesi, suola ja mausteet." },
	{ trig: / majonees/, out: { nom: "majoneesi", gen: "majoneesin" }, story: "Majoneesi eli öljy-kananmunakastike on paksua emulsiokastiketta, joka valmistetaan ruokaöljystä, kananmunasta (kokonaisista tai keltuaisista), etikasta ja mausteista. Etikan sijaan käytetään usein myös sitruunaa." },

	// Snacks
	{ trig: / keks(i|e)/, out: { nom: "keksi", gen: "keksin" }, story: "Keksintö on olemassa olevan ongelman tai tarpeen uusi tai yllättävä ratkaisu joka on sovellettavissa käytäntöön. Se on innovatiivinen esine, prosessi tai tekniikka ja usein keksintö perustuu jo olemassa olevan tekniikan uudenlaiseen soveltamiseen." },
	{ trig: / kark(k)*(i|e)/, out: { nom: "makeinen", gen: "makeisen" }, story: "Makeiset eli karkit ovat syötäviä elintarvikkeita, joiden keskeinen ainesosa on sokeri tai muu makeutusaine. Makeisia ei syödä ravinnoksi, vaan lähinnä makeuden tuottaman mielihyvän vuoksi." },
	{ trig: / sukla(a|i)/, out: { nom: "suklaa", gen: "suklaan" }, story: "Suklaa on ruoka- ja nautintoaine. Sitä valmistetaan lisäämällä kaakaopavuista valmistettavaan kaakaomassaan yleensä sokeria ja maitosuklaan tapauksessa myös maitoa tai maitojauhetta, erilaisia mausteita sekä koostumusta parantavia aineita." },
	{ trig: / sips(i|e)/, out: { nom: "perunalastu", gen: "perunalastun" }, story: "Perunalastut ovat kokonaisista perunoista höylättyjä uppopaistettuja ja maustettuja lastuja. Monet kutsuvat perunalastuja sipseiksi (< engl. potato chip, ’perunalastu’), mutta sipseillä voidaan tarkoittaa myös muuta pikkupurtavaa, kuten maissilastuja ja juustonaksuja." },
	{ trig: /(laku|lakrits(i|e))/, out: { nom: "lakritsi", gen: "lakritsin" }, story: "Lakritsihappo (eli glysyrritsiini, glykyrritsiini tai glykyrritsiinihappo) on lakritsikasvissa ja monien Glycyrrhiza-suvun kasveissa oleva makea aine. Sen suolat antavat lakritsikasvin juuresta osin tehdylle lakritsille lakritsimaisen maun ja osan sen makeudesta." },
	{ trig: /salmiak(k)*(i|e)/, out: { nom: "salmiakki", gen: "salmiakin" }, story: "Salmiakki on ammoniumkloridilla eli salmiakilla maustettu lakritsimakeinen. Maultaan salmiakki on samaan aikaan sekä makea että suolainen. Salmiakkia syödään lähinnä Pohjoismaissa, Pohjois-Saksassa ja Alankomaissa." },
	{ trig: /pop(c|k)orn/, out: { nom: "popcorn", gen: "popcornin" }, story: "Popcorn on Gershon Kingsleyn vuonna 1969 Music to Moog By -albumillaan julkaisema instrumentaalikappale. Kappale julkaistiin myös singlenä vailla mainittavaa menestystä." },
	{ trig: / (pizz(a|o)|pits(a|o))/, out: { nom: "pizza", gen: "pizzan" }, story: "Pizza (suom. [ˈpitsɑ]) tai pitsa on italialaisperäinen, yksinkertaisimmassa muodossaan uunissa paistettu, litteä, usein pyöreä leipä, joka on päällystetty yleensä tomaateilla tai tomaattikastikkeella, juustolla sekä muilla valinnaisilla täytteillä." },
	{ trig: /hotdog/, out: { nom: "hotdog", gen: "hotdogin" }, story: "Hotdog on rap-artisti Pyhimyksen ensimmäinen Lika-Aki -taiteilijanimellä julkaistu albumi. Se julkaistiin digijulkaisuna, lp-levynä ja c-kasetilla 3. maaliskuuta 2017." },
	{ trig: /makkar(a|o)/, out: { nom: "makkara", gen: "makkaran" }, story: "Makkara on suoleen tai muuhun päällykseen tai muottiin tehty elintarvike, jonka oleellisena valmistusaineena on liha, elimet tai niihin verrattavat ainesosat. Makkara tarjoillaan yleensä kuoren kanssa, jos makkaran kuorena on käytetty niin sanottua luonnonkuorta eli pätkää puhdistettua eläimen suolta. Kollageenista, selluloosasta sekä paperista ja viskoosista valmistetut keinosuolet ovat myös syötäviä, toisin kuin muovikuori." },
	{ trig: /lihapull/, out: { nom: "lihapulla", gen: "lihapullan" }, story: "Lihapullat ovat yleensä pyöreitä, pääasiassa jauhelihasta valmistettuja lihapyöryköitä. Perinteinen lihapullataikina koostuu usein lihan lisäksi korppujauhoista, sipulista, kananmunista ja mausteista. Pullat paistetaan pannulla tai uunissa." },
	{ trig: /pakastekak(k|u)/, out: { nom: "paskastekakku", gen: "pakastekakun" }, story: "Mud cake eli mutakakku on mehevän kostea suklaakakku, joka on sulatuksen jälkeen valmis tarjottavaksi. Mud caken kanssa maistuu vaniljajäätelö tai kermavaahto." },
	{ trig: /valmiskak(k|u)/, out: { nom: "valmiskakku", gen: "valmiskakku" }, story: "Mud cake eli mutakakku on mehevän kostea suklaakakku, joka on sulatuksen jälkeen valmis tarjottavaksi. Mud caken kanssa maistuu vaniljajäätelö tai kermavaahto." },

	// Other
	{ trig: / voi(n|ta)*(kin)* /, out: { nom: "voi", gen: "voin" }, story: "Voi on ruotsalainen elokuussa 2018 perustettu startup-yritys, joka tarjoaa puhelinsovelluksella vuokrattavia sähköpotkulautoja. Voin palvelu toimii 40 kaupungissa ja 11 maassa ympäri Eurooppaa." },
	{ trig: /margariin/, out: { nom: "margariini", gen: "margariinin" }, story: "Margariinihappo tai Heptadekaanihappo on tyydyttynyt rasvahappo. Yhdistettä esiintyy maitorasvassa ja kasvirasvassa pieninä pitoisuuksina (< 0,5 %) sekä syntyy myös märehtimisprosessissa." },
	{ trig: /juustoraaste/, out: { nom: "juustoraaste", gen: "juustoraasteen" }, story: "Juustoraaste valmistetaan käyttämällä juustoraastinta. Juustoraastin on juuston pienemmiksi paloiksi raastamisessa käytetty työkalu." },
	{ trig: / juusto/, out: { nom: "juusto", gen: "juuston" }, story: "Juusto on maidosta saostamalla ja puristamalla valmistettu ravintotuote. Juustot luokitellaan valmistustavan mukaan tuorejuustoihin ja kypsytettyihin juustoihin." },
	{ trig: / hiiv(a|o)/, out: { nom: "hiiva", gen: "hiivan" }, story: "Hiivat on yleisnimitys yksisoluisille sienille, jotka eivät muodosta rihmastoja tai itiöemiä. Nimitys viittaa nykyisin ulkomuotoon ja elintapaan, ei tiettyyn yksittäiseen taksoniin eli tieteellisesti luokiteltuun eliöryhmään." },
	{ trig: /öljy/, out: { nom: "öljy", gen: "öljyn" }, story: "Öljy eli raakaöljy tai maaöljy, on maaperässä muinaisista eliöistä muodostunut hiilivetyjen seos. Öljyä käytetään laajalti polttoaineena ja raaka-aineena synteettisiä aineita valmistettaessa." },

];

export const iDontGetIt = "Nyt en valitettavasti ihan ymmärtänyt mitä tarkoitit. Voitko muotilla pyyntösi selkeämmin.";

export const removeAllBut = "Pahoittelut, ymmärsin väärin mitä tarkoitit. Poistan kaikki edelliset merkinnät listasta!";

export const psychosisTexts = [
	"Ensin haluat laittaa asiota, sitten ottaa pois, ja sitten taas laittaa takasin. Koita nyt jo päättää! Minulla on parempaakin tekemistä kuin toteuttaa käyttäjien mielivaltaisia haluja!",
	`Please select a language below:
	- Morrison
	- Hyberbolic algebra
	- ENG`,
	"Hvala!",
	"Elfogytak az előfizetésében lévő tokenek. Kérjük, szerezzen be további tokeneket a szolgáltatás további használatához.",
	"Érvénytelen válasz a ai.torment-nexus.com/api/v1/: 500 Belső szerverhiba."
];

export const psycErrorText = "Invalid response from ai.torment-nexus.com/api/v1/: 500 Internal server error";
