import { Component } from "peura-ui";

const loginUsernameTemplate = `
	<div class="Login_Title">{greetText}</div>
	<div class="LoginUserPassword_Right">
		<div class="LoginUserPassword_RightTop">
			<input class="{inputClass}" value="{username}" placeholder="Enter your username" />
		</div>
		<div class="LoginUserPassword_RightBottom">
			<button class="Login_Butt-Highlight" onclick="{progress}">Next</button>
		</div>
	</div>
`;

export default class LoginUsernameUI extends Component {
	constructor(progress: (name: string) => void, username?: string) {
		super(loginUsernameTemplate, {
			inputClass: "Login_Input",
			progress: () => {
				if (this.hooks.username !== "") {
					this.hooks.inputClass = "Login_Input";
					progress(this.hooks.username);
				}
				else {
					this.hooks.inputClass = "Login_Input-Error";
				}
			}
		});
		this.hooks.greetText = username ? `Hello ${username}` : "Good evening";
	}
}
