import { Component } from "peura-ui";

const loginPasswordTemplate = `
	<div class="Login_Title">Hi {username}</div>
	<div class="LoginUserPassword_Right">
		<div class="LoginUserPassword_RightTop">
			<input class="{inputClass}" type="password" value="{password}" placeholder="Enter your password" />
		</div>
		<div class="LoginUserPassword_RightBottom">
			<button class="Login_Butt-Secondary" onclick="{stall}">Forgot password?</button>
			<button class="Login_Butt-Highlight" onclick="{progress}">Next</button>
		</div>
	</div>
`;

export default class LoginPasswordUI extends Component {
	constructor(progress: () => void, stall: () => void, username: string) {
		super(loginPasswordTemplate, {
			inputClass: "Login_Input",
			progress: () => {
				if (this.hooks.password !== "") {
					this.hooks.inputClass = "Login_Input";
					progress();
				}
				else {
					this.hooks.inputClass = "Login_Input-Error";
				}
			},
			stall,
			username
		});
	}
}
