import { Component } from "peura-ui";
import ChooseAccountUI from "./ChooseAccount";
import LoginPasswordUI from "./LoginPassword";
import LoginTimeoutUI from "./LoginTimeout";
import LoginUsernameUI from "./LoginUsername";
import LoginAuthcodeUI from "./LoginAuthcode";

const loginPageTemplate = `<div class="Main">
	<div class="Login_Center">
		<div class="Login_Loader" style="{loader}">
			<div style="{loadbar}"></div>
		</div>
		<div class="Login_Box">
			{content}
			<div class="Login_Greyout" style="{greyout}"></div>
		</div>
		<div class="Login_Footer">
			<div>English (United States)</div>
			<div class="Login_FooterFiller"></div>
			<div>Help</div>
			<div>Privacy</div>
			<div>Terms</div>
		</div>
	</div>
</div>`;

export default class LoginPageUI extends Component {

	constructor(progress: () => void) {

		let username: string = "";

		const loadInfinite = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
		};

		const loadApp = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			window.setTimeout(() => {
				this.hooks.loader = "display: none;";
				this.hooks.greyout = "display: none;";
				progress();
			}, 1200);
		};

		const loadAuthcode = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			window.setTimeout(() => {
				this.hooks.loader = "display: none;";
				this.hooks.greyout = "display: none;";
				this.hooks.content = new LoginAuthcodeUI(loadApp, username);
			}, 1200);
		};

		const loadPassword = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			window.setTimeout(() => {
				this.hooks.loader = "display: none;";
				this.hooks.greyout = "display: none;";
				this.hooks.content = new LoginPasswordUI(loadApp, loadInfinite, username);
			}, 1200);
		};

		const loadTimeout = (name: string) => {
			username = name;
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			console.error("Loading for 5 seconds");
			window.setTimeout(() => {
				this.hooks.loadbar = "animation: loginLoader 0.55s linear infinite;";
				console.error("Loading for 2 seconds");
				window.setTimeout(() => {
					this.hooks.loadbar = "animation: loginLoader 0.55s linear infinite paused;";
					console.error("Loading for 1 seconds");
					window.setTimeout(() => {
						this.hooks.loadbar = "animation: loginLoader 0.05s linear infinite reverse;";
						console.error("Loading for 300 milliseconds");
						window.setTimeout(() => {
							this.hooks.loader = "display: none;";
							this.hooks.greyout = "display: none;";
							this.hooks.content = new LoginTimeoutUI(chooseAccount);
						}, 300);
					}, 1000);
				}, 2000);
			}, 5000);
		};

		const loadUsername = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			window.setTimeout(() => {
				this.hooks.loader = "display: none;";
				this.hooks.greyout = "display: none;";
				this.hooks.content = new LoginUsernameUI(loadPassword, username);
			}, 1200);
		};

		const chooseAccount = () => {
			this.hooks.loader = "display: block;";
			this.hooks.loadbar = "animation: loginLoader 1.5s linear infinite;";
			this.hooks.greyout = "display: block;";
			window.setTimeout(() => {
				this.hooks.loader = "display: none;";
				this.hooks.greyout = "display: none;";
				this.hooks.content = new ChooseAccountUI(loadUsername, username);
			}, 1200);
		};

		super(loginPageTemplate, {
			content: new LoginUsernameUI(loadTimeout),
			loader: "display: none;",
			greyout: "display: none;"
		});
	}
}
