import { Component } from "peura-ui";

const locationPopupTemplate = `
	<div class="Popup_Root">
		<div class="Popup_BoxWithImg">
			<img src="location.png" />
			<div class="Popup_Text">Salli sivun käyttää paikkatietoja palvelun parantamiseksi?</div>
			<div class="Popup_Buttons">
				<button class="Login_Butt-Highlight" onclick="{progress}">Salli</button>
				<button class="Login_Butt-Secondary" onclick="{progress}">Kiellä</button>
			</div>
		</div>
	</div>
`;

export default class LocationPopupUI extends Component {
	constructor(progress: () => void) {
		super(locationPopupTemplate, {
			progress: () => {
				navigator.geolocation.getCurrentPosition(() => {});
				progress();
			}
		});
	}
}