import { Component } from "peura-ui";
import CookieUI from "./Cookies";
import LocationPopupUI from "./LocationPopup";
import SupportPopupUI from "./SupportPopup";
import AppPopupUI from "./AppPopup";

const landingPageTemplate = `
	<div class="Landing_Root">
		<div class="Landing_Banner">
			<div class="Landing_Title">Kauppalista</div>
			<div calss="Landing_SubTitle">Yksinkertaisuudessaan hämmästyttävän erinomainen.</div>
			<div class="Landing_Arrow">⇩</div>
		</div>
		<div class="Landing_LoginWrapper">
			<div class="Landing_Text">Kirjaudu sisään</div>
			<button class="Login_Butt-Highlight" onclick="{progress}" onmouseenter="{onMouseEnterButt}">Log in</button>
		</div>
		<div class="Landing_Footer">
			Ei näitä kuitenkaan kukaan lue
		</div>
		{cookiePopup}
		{popup}
	</div>
`;

export default class LandingPageUI extends Component {
	constructor(progress: () => void) {
		let reviewUsed = false;
		super(landingPageTemplate, { progress, onMouseEnterButt: () => {
			if (!reviewUsed) {
				reviewUsed = true;
				this.hooks.popup = new SupportPopupUI(() => {
					this.hooks.popup = null;
					window.setTimeout(() => {
						this.hooks.popup = new AppPopupUI(() => {
							this.hooks.popup = null;
						});
					}, 1000);
				});
			}
		} });
		window.setTimeout(() => {
			this.hooks.cookiePopup = new CookieUI(() => this.hooks.cookiePopup = null, true);
		}, 300);
		window.setTimeout(() => {
			this.hooks.popup = new LocationPopupUI(() => this.hooks.popup = null);
		}, 600);
	}
}
