import { Component } from "peura-ui";
import type { IItem } from "./interfaces";

const itemRowTemplate = `<div class="ListPage_ItemRow">{itemName}</div>`;

export default class ItemRowUI extends Component {

	public item: string;

	constructor(item: IItem | string) {
		if (typeof item === "string") {
			super(itemRowTemplate, { itemName: item });
			this.item = item;
		}
		else {
			super(itemRowTemplate, { itemName: item.out.nom });
			this.item = item.out.nom;
		}
	}
}