import { Component } from "peura-ui";

const cookieRowTemplate = `
	<div class="Cookie_Row">
		<div class="Cookie_RowLeft">
			<div>{text}</div>
			<div>Shared with {partners} partners</div>
		</div>
		<div class="Cookie_RowRight">
			<button class="{className1}" onclick="{onClick1}">Suostumus</button>
			<button class="{className2}" onclick="{onClick2}">Oikeutettu etu</button>
		</div>
	</div>;
`;

class CookieRowUI extends Component {
	constructor(row: { partners: number, text: string }) {
		super(cookieRowTemplate, row);
		let toggle1 = false;
		let toggle2 = true;
		this.hooks.onClick1 = () => {
			toggle1 = !toggle1;
			this.hooks.className1 = `Cookie_RowButton${toggle1 ? "-Active" : "-Inactive"}`;
		}
		this.hooks.onClick2 = () => {
			toggle2 = !toggle2;
			this.hooks.className2 = `Cookie_RowButton${toggle2 ? "-Active" : "-Inactive"}`;
		}
		this.hooks.className1 = `Cookie_RowButton${toggle1 ? "-Active" : "-Inactive"}`;
		this.hooks.className2 = `Cookie_RowButton${toggle2 ? "-Active" : "-Inactive"}`;
	}
}

const cookieTemplate = `
	<div class="Cookie_Root">
		<div class="{boxClassName}">
			<div class="Cookie_TitleWrapper">
				<div class="Cookie_Title">We respect your privacy</div>
				<button class="Cookie_Butt" style="background: #e5e5e5" onclick="{rejectCookies}">Options</button>
			</div>
			<div class="Cookie_Description" style="{contentStyle1}">
				<p>We use cookies and blah blah blah no one actually reads these and you shouldn't either. Just accept the cookies like a good little peasant you are.</p>
				<ul>
					<li>Essential cookies are required to use the Service and are necessary for the site to work as intended.</li>
					<li>Optional cookies are used to show you paid content and to provide features like user tormenting. These cookies are optional.</li>
					<li>Cookies from other vendors: Are you still reading? Please don't bother :) These cookies are used to track your every movement across the whole internet through our extensive spynetwork, and sold to facist governments to enable genocides. These cookies are optional but good luck trying to disable them.</li>
				</ul>
				<p>You have control over the optional cookies we use*. Learn more about how we use cookies, review, or change your choices at any time in our <a class="Cookie_TextHighlight">Cake Policy</a>.</p>
				<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.</p>
				<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.</p>
				<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.</p>
				<p>Lorem ipsum dolor sit amet consectetur adipiscing elit. Quisque faucibus ex sapien vitae pellentesque sem placerat. In id cursus mi pretium tellus duis convallis. Tempus leo eu aenean sed diam urna tempor. Pulvinar vivamus fringilla lacus nec metus bibendum egestas. Iaculis massa nisl malesuada lacinia integer nunc posuere. Ut hendrerit semper vel class aptent taciti sociosqu. Ad litora torquent per conubia nostra inceptos himenaeos.</p>
			</div>
			<div class="Cookie_Description" style="{contentStyle2}">
				<p>Oh, you want to make it difficult?</p>
				<p>Let it be so.</p>
				<div>{cookieRows}</div>
			</div>
			<div class="Cookie_ButtonWrapper" style="{buttonStyle1}">
				<button class="Cookie_Butt-Accept" onclick="{acceptCookies}">Accept all</button>
				<button class="Cookie_Butt" style="background: #bec9da;" onclick="{acceptCookies}">I don't want to not-allow cookies</button>
				<button class="Cookie_Butt" style="background: #c5c8ca;" onclick="{acceptCookies}">I'm ok with this</button>
				<button class="Cookie_Butt" style="background: #cac7c5;" onclick="{acceptCookies}">Don't reject</button>
				<button class="Cookie_Butt" style="background: #c8bed6;" onclick="{acceptCookies}">Dismiss cookie options</button>
				<button class="Cookie_Butt" style="background: #d4d4c0;" onclick="{acceptCookies}">Just make it go away</button>
			</div>
			<div class="Cookie_ButtonWrapper" style="{buttonStyle2}">
				<button class="Cookie_Butt-Accept" onclick="{acceptCookies}">Accept all</button>
			</div>
		</div>
	</div>
`;

export default class CookieUI extends Component {
	constructor(progress: () => void, modal: boolean) {
		const cookies = [
			{ partners: 6, text: "Tietojen tallentaminen laitteelle ja/tai laitteella olevien tietojen käyttö" },
			{ partners: 16, text: "Tietojen jakaminen tiedusteluviranomaisten kanssa" },
			{ partners: 116, text: "Rajoitettujen tietojen käyttö mainosten valitsemiseksi" },
			{ partners: 516, text: "Käyttäjien stalkkaaminen" },
			{ partners: 1016, text: "Personoidun mainosprofiilin muodostaminen" },
			{ partners: 4120, text: "Asiakkaiden tiedoille naureskelu firman pikkujouluissa" },
			{ partners: 3.14, text: "Profiilin käyttö kohdennetun mainonnan valitsemiseksi" },
			{ partners: 34012, text: "Salasanojen myynti kansainvälisille hakkeriryhmille" },
			{ partners: 12043, text: "Personoidun sisältöprofiilin muodostaminen" },
			{ partners: 3, text: "Tietojen käyttö tekoälyn ihmiskunnan valloituksessa" },
			{ partners: 124243, text: "Profiilien käyttö personoidun sisällön valitsemiseksi" },
			{ partners: 332614, text: "Oikeus tietojen keräämiseen ilman käyttäjän suostumusta" },
			{ partners: 270001, text: "Mainonnan tehokkuuden mittaaminen" },
			{ partners: 1, text: "Tietojen käyttö Instanssi.orgin salaisen poliisin tueksi" },
			{ partners: 3643061, text: "Sisällön tehokkuuden mittaaminen" },
			{ partners: 41643, text: "Sisällön asiattomuuden kehittäminen" },
			{ partners: 3261008, text: "Yleisöjen ymmärtäminen eri lähteistä peräisin olevien tietojen, tilastojen tai yhdistelmien avulla" },
			{ partners: 1, text: "Tietojen käyttö tavoilla jotka menevät teiltä tavallisilta kuolevaisilta yli hilseen " },
			{ partners: 0, text: "Palvelujen kehittäminen ja parantaminen" },
			{ partners: 1000, text: "Palvelujen \"kehittäminen\" ja \"parantaminen\"" },
			{ partners: 79756130, text: "Rajoitettujen tietojen käyttö sisällön valitsemiseen" },
			{ partners: 9123167, text: "Tietojen käyttö ylläolevasta valinnasta huolimatta" },
			{ partners: 231209164, text: "Palvelun sisällönjakelukumppanit" },
			{ partners: 6426429617, text: "Palvelun rikoskumppanit" },
			{ partners: 481, text: "Palvelun markkinoinnissa hyödynnettävät mainosteknologiakumppanit" },
			{ partners: -1, text: "Null" },
			{ partners: 501659525, text: "Palvelun yleisömittaus" },
			{ partners: 565, text: "Palvelun toteuttama mainonnan kohdentaminen ja mittaus" },
			{ partners: 51265129, text: "Palvelun toteuttama asiakaskokemuksen parantaminen" },
			{ partners: 82, text: "Analytiikan hyödyntäminen palvelun tuotekehityksessä ja raportoinnissa" },
			{ partners: 57, text: "Tietoturva, väärinkäytösten ehkäiseminen ja virheiden korjaaminen" },
			{ partners: 11260134618, text: "Mainonnan ja sisällön tekninen jakelu" },
			{ partners: 7242033166000, text: "Tallenna ja ilmaise tietosuojavalintasi" },
			{ partners: 224601011, text: "Palvelun perustoiminnallisuudet" },
			{ partners: 6424662434328, text: "Persoitujen tietojen käyttö vähemmistöjen vainoamiseen" },
		];
		const boxClassName = modal ? "Cookie_BoxModal" : "Cookie_BoxBar";
		super(cookieTemplate, {
			cookieStyle: "display: flex;",
			buttonStyle1: "display: flex;",
			buttonStyle2: "display: none;",
			contentStyle1: "display: flex;",
			contentStyle2: "display: none;",
			acceptCookies: progress,
			rejectCookies: () => {
				this.hooks.buttonStyle1 = "display: none;";
				this.hooks.buttonStyle2 = "display: flex;";
				this.hooks.contentStyle1 = "display: none;";
				this.hooks.contentStyle2 = "display: flex;";
				this.hooks.cookieRows = [...cookies, ...cookies].map(cookie => new CookieRowUI(cookie));
			},
			boxClassName
		});
	}
}
