// zig fmt: off
const p: [256]u8 = .{
    151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53,
    194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99,
    37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75,
    0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32,
    57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136,
    171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166,
    77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230,
    220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54,
    65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187,
    208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86,
    164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250,
    124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212,
    207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42,
    223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70,
    221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253,
    19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104,
    218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12,
    191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107,
    49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176,
    115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93,
    222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66,
    215, 61, 156, 180
};
// zig fmt: on

const perm = init: {
    var a: [512]u8 = undefined;
    for (0..512) |i| {
        a[i] = p[i & 255];
    }
    break :init a;
};

// zig fmt: off
const grad3: [12][3]i32 = .{
    .{1,1,0}, .{-1,1,0}, .{1,-1,0}, .{-1,-1,0},
    .{1,0,1}, .{-1,0,1}, .{1,0,-1}, .{-1,0,-1},
    .{0,1,1}, .{0,-1,1}, .{0,1,-1}, .{0,-1,-1}
};
// zig fmt: on

fn dot2(g: []const i32, x: f32, y: f32) f32 {
    return @as(f32, @floatFromInt(g[0])) * x + @as(f32, @floatFromInt(g[1])) * y;
}

// 2D simplex noise. Returns values in range [-1, 1]
pub fn simplex2(x: f32, y: f32) f32 {
    var n0: f32 = undefined;
    var n1: f32 = undefined;
    var n2: f32 = undefined;

    const f2: f32 = 0.5 * (@sqrt(3.0) - 1.0);
    const s: f32 = (x + y) * f2;
    const i: i32 = @intFromFloat(@floor(x + s));
    const j: i32 = @intFromFloat(@floor(y + s));

    const g2: f32 = (3.0 - @sqrt(3.0)) / 6.0;
    const t: f32 = @as(f32, @floatFromInt(i + j)) * g2;
    const xx0: f32 = @as(f32, @floatFromInt(i)) - t;
    const yy0: f32 = @as(f32, @floatFromInt(j)) - t;
    const x0: f32 = x - xx0;
    const y0: f32 = y - yy0;

    var ii1: i32 = undefined;
    var jj1: i32 = undefined;
    if (x0 > y0) {
        ii1 = 1;
        jj1 = 0;
    } else {
        ii1 = 0;
        jj1 = 1;
    }

    const x1: f32 = x0 - @as(f32, @floatFromInt(ii1)) + g2;
    const y1: f32 = y0 - @as(f32, @floatFromInt(jj1)) + g2;
    const x2: f32 = x0 - 1.0 + 2.0 * g2;
    const y2: f32 = y0 - 1.0 + 2.0 * g2;

    const ii: i32 = i & 255;
    const jj: i32 = j & 255;
    const gi0: i32 = @mod(perm[@intCast(ii + perm[@intCast(jj)])], 12);
    const gi1: i32 = @mod(perm[@intCast(ii + ii1 + perm[@intCast(jj + jj1)])], 12);
    const gi2: i32 = @mod(perm[@intCast(ii + 1 + perm[@intCast(jj + 1)])], 12);

    var t0: f32 = 0.5 - x0 * x0 - y0 * y0;
    if (t0 < 0.0) {
        n0 = 0.0;
    } else {
        t0 *= t0;
        n0 = t0 * t0 * dot2(&grad3[@intCast(gi0)], x0, y0);
    }

    var t1: f32 = 0.5 - x1 * x1 - y1 * y1;
    if (t1 < 0.0) {
        n1 = 0.0;
    } else {
        t1 *= t1;
        n1 = t1 * t1 * dot2(&grad3[@intCast(gi1)], x1, y1);
    }

    var t2: f32 = 0.5 - x2 * x2 - y2 * y2;
    if (t2 < 0.0) {
        n2 = 0.0;
    } else {
        t2 *= t2;
        n2 = t2 * t2 * dot2(&grad3[@intCast(gi2)], x2, y2);
    }

    return 70.0 * (n0 + n1 + n2);
}
