Demo.prototype.sceneSigma = function () {
    this.setScene('sigma');

    const cycleLength = 2.0 ;
    const sigmaCount = 5;
    const zStart = -40;
    const zEnd = 1;
    const zRange = zEnd - zStart;

    for (let i = 0; i < sigmaCount; i++) {
        ((index) => {
            let startOffset = index / sigmaCount;

            this.loader.addAnimation([{
                image: {
                    name: 'images/sigma.png'
                },
                perspective: '3d',
                position: [{
                    x: 0,
                    y: 0,
                    z: () => {
                        let progress = (getSceneTimeFromStart() / cycleLength + startOffset) % 1.0;
                        return zStart + progress * zRange;
                    }
                }],
                scale: [{ uniform2d: 6.0 }],
                color: [{
                    r: () => {
                        const cycle = Math.floor(getSceneTimeFromStart() / cycleLength + startOffset);
                        Utils.setSeed(cycle * 1000 + index * 3);
                        return Utils.random() * 0.02;
                    },
                    g: () => {
                        const cycle = Math.floor(getSceneTimeFromStart() / cycleLength + startOffset);
                        Utils.setSeed(cycle * 1000 + index * 3 + 5);
                        return Utils.random() * 0.02;
                    },
                    b: () => {
                        const cycle = Math.floor(getSceneTimeFromStart() / cycleLength + startOffset);
                        Utils.setSeed(cycle * 1000 + index * 3 + 12);
                        return Utils.random() * 0.02;
                    },
                    a: () => {
                        const progress = (getSceneTimeFromStart() / cycleLength + startOffset) % 1.0;
                        if (progress < 0.1) {
                            return progress / 0.1;
                        } else if (progress > 0.9) {
                            return (1.0 - progress) / 0.1;
                        }
                        return 1.0;
                    }
                }],
                angle: [{
                    degreesZ: () => {
                        const cycle = Math.floor(getSceneTimeFromStart() / cycleLength + startOffset);
                        Utils.setSeed(cycle * 999 + index * 7);
                        return Utils.random() * 360;
                    }
                }],
                additive: true,

            }]);
        })(i);
    }
};
