
Demo.prototype.sceneMaxxingCommon = function () {

  this.loader.addAnimation([{
    image: {
      name: 'images/introbg.png'
    },
    perspective: '2d',
    position: [{
      x: () => 0,
      y: () => 0,
      z: 0
    }],
    angle: [{
      degreesZ: () => Math.sin(getSceneTimeFromStart()) * 5
    }],
    scale: [{ uniform2d: 1.2 }],
    color: [{
      r: .7,
      g: 0,
      b: 0

    }],

  }]);

  this.loader.addAnimation({
    "light": {
        "type": "Ambient",
        "properties": { "intensity": 2.0 },
        "castShadow": false
    }
    ,"color": [{
        "r": 1.0, "g": 1.0, "b": 1.0
    }]
  });

    this.loader.addAnimation({
      "light": {
          "type": "Directional",
          "properties": { "intensity": 1.5 },
          "castShadow": false
      }
      ,position:[{x:0.5,y:3,z:2}]
    });    

    const particleCount = 150;
  const emojiList = [
  '🍞','🥖',
  ];

  for(let emojiIndex = 0; emojiIndex < emojiList.length; emojiIndex++) {
    const emoji = emojiList[emojiIndex];
    let particles = new Array(particleCount);
    for (let i = 0; i < particleCount; i++) {
      // circle around center
      const startPercent = Utils.random();
      const startPercent2 = Utils.random();
      const startPercent3 = Utils.random();
      const startRadius = 1.5 + startPercent3 * 2.0;
      particles[i] = {
        x: 0,
        y: 0,
        z: -1,
        scale: 0.5,
        startPercent: startPercent,
        startPercent2: startPercent2,
        startPercent3: startPercent3,
        startRadius: startRadius
      };
    }
    this.loader.addAnimation({
      image: emoji,
      position: [
        {
          x: 0,
          y: -1,
          z: 0
        }
      ],
      /*angle:[{             
          degreesY:()=>getSceneTimeFromStart()*60,              
        }],*/
      /*angle: [{
        degreesY: ()=> getSceneTimeFromStart() * 60,
        degreesX: ()=> getSceneTimeFromStart() * 60
     }],*/
      scale: [{ uniform3d: 1.0 }],
      "perspective": "3d",
      "billboard": true,
      "additive": true,
      /*"material":{
        "blending": 'AdditiveBlending',
        "transparent":true,
        "depthWrite":false,
      },*/
      color: [{r:1,g:1,b:1}],
      //"scale":[{"uniform3d":.1}],
      "instancer": {
        "count": particleCount,
        "runInstanceFunction": (properties) => {

          const i = properties.index;
          const count = properties.count;
          const time = properties.time;
          let object = properties.object;
          let color = properties.color;

          const particle = particles[i]; 

          const w = Sync.get('AspectRatio:width');
          const h = Sync.get('AspectRatio:height');
          const aspectRatio = w/h;

          const vortex = () => {
            const percent = (time*0.1+particle.startPercent) % 1.0;
            const percent2 = (time*0.1+particle.startPercent2) % 1.0;
            const theta = percent * Math.PI * 2;
            const phi = percent2 * Math.PI;
            const radius = 6.0;
            const r = radius/2 + radius/2*particle.startPercent3;

            const x = r * Math.sin(phi) * Math.cos(theta) * aspectRatio;
            const y = r * Math.sin(phi) * Math.sin(theta) + 0.5;
            const z = r * Math.cos(phi) + 1;
            let scale = particle.scale + particle.startRadius/5.0;// * Math.min(time * 0.1, 1.0);

            return [x, y, z, scale];
          };

          const [x, y, z, scale] = vortex();

          object.position.x = x;
          object.position.y = y;
          object.position.z = z;


            color.r = Sync.get('Maxxing'+emojiIndex+':r', 1);
            color.g = Sync.get('Maxxing'+emojiIndex+':g', 1);
            color.b = Sync.get('Maxxing'+emojiIndex+':b', 1);
            color.a = Sync.get('Maxxing'+emojiIndex+':a', 1) * (i/count > Sync.get('Maxxing'+emojiIndex+':countPercent', Math.min(time/12,1.0)) ? 0 : Math.min(1, time/8));
            /*color.a = Math.max(Math.sin(time*18.0), 0.0);
            const percent = time/6.0;
            if (i > particleCount*percent) {
              color.a = 0.0;
            }*/

          //}

          object.scale.x = scale;
          object.scale.y = scale;
          object.scale.z = scale;
        }
      }
    });
  }
};

Demo.prototype.sceneMaxxing = function () {
  this.setScene('maxxing');

  this.sceneMaxxingCommon();

    //this.setScene('maxxing2'); // no feedback
    //this.sceneMaxxingCommon();

  this.loader.addAnimation({
    start: 4,
      object: 'obj/bread.obj',
      position: [{ x: 0, y: 0, z: -10 }],
      prevTime: 0,
      angle:[{             
          degreesZ:()=>getSceneTimeFromStart()*60, 
            
        }],
        scale:[{"uniform3d":0.0},{duration:4, uniform3d: 2.0}],
        runFunction: (animation) => {
            const t = getSceneTimeFromStart();
            if (t > animation.prevTime) {
                animation.prevTime = t + 0.1;
                animation.angle[0].degreesX = 90 + (Math.random() * 40 - 20);
                animation.angle[0].degreesY =  (Math.random() * 40 - 20);

            } else if (Math.abs(t - animation.prevTime) > 0.5) {
                animation.prevTime = 0;
            }
        }        
  });

  this.loader.addAnimation({
    start: 4,
      text: {
          string: "mogged\n   Harri",
          name: [
              'font/TikTokSans-Bold.ttf',
              'font/TikTokSans-Light.ttf',
              'font/TikTokSans-Regular.ttf',
              'font/ComicSans.ttf'
          ][1],
          parameters: { size: 5, depth: 0.01, bevelEnabled: false }
      },
      perspective: "3d",
      position: [{ x: -2.0, y: 1.0, z: 0 }],
      scale: [{ uniform3d: 1.4 }],
  });

  this.loader.addAnimation({
    image: 'sceneMaxxing/mogged_harri.png',
    position:[{x:-0.75,y:()=>Math.sin(getSceneTimeFromStart()*6)*.04-0.17},{duration:2, x: -0.35}],
    scale:[{uniform2d:1.0}]
  });

  this.loader.addAnimation({
    start:9+4,
      text: {
          string: "MOGGeR\n  Ville",
          name: [
              'font/TikTokSans-Bold.ttf',
              'font/TikTokSans-Light.ttf',
              'font/TikTokSans-Regular.ttf',
              'font/ComicSans.ttf'
          ][0],
          parameters: { size: 5, depth: 0.01, bevelEnabled: false }
      },
      perspective: "3d",
      position: [{ x: 2.1, y: 1.0, z: 0 }],
      scale: [{ uniform3d: 1.4 }],
  });

  // GFX by: Oon toivonu joulupukilta of jml
  this.loader.addAnimation({
    start:9,
    image: 'sceneMaxxing/mogger_ville.png',
    position:[{x:0.75,y:()=>Math.sin(3.14+getSceneTimeFromStart()*6)*.04-0.17},{duration:2, x: 0.35}],
    scale:[{uniform2d:1.0}]
  });

  //};
  this.textWriter("CARBMAXXING WITH AMOG", {
      fontId: 1,
      y: .43,
      x: -.115,
      fontScale: 0.3,
      bgScaleY: .12,
      bgY: .06
  });

  const emojiWrite = ['💪','💪','💪','💪','💪','💦','💦'];
  emojiWrite.forEach((emojiChar, index) => {
    this.addAnimationToMainScene({
        image: emojiChar,  // The emoji character itself
        perspective: '2d',
        position: [{ x: 0.12 + index * 0.04, y: .465, z: 0 }],
        scale: [{ uniform2d: 0.23 }],
    });
  });




};
