Demo.prototype.sceneEmojis = function () {
  (() => {
    const renderCharacterToCanvas = (character) => {
        const size = 512;

        const canvas = document.createElement('canvas');
        canvas.width = size;
        canvas.height = size;

        const context = canvas.getContext('2d');
        context.font = `${size / 2}px monospace`;
        context.textAlign = 'center';
        context.textBaseline = 'middle';
        context.textRendering = 'geometricPrecision';
        context.fillText(character, size / 2, size / 2, size);

        return {
            image: canvas,
            properties: {
                magFilter: 'LinearFilter',
                minFilter: 'LinearMipmapLinearFilter'
            }
        };
    };

    // https://unicode.org/emoji/charts/full-emoji-list.html#1f922
    const emojiList = [
        '😂', '😃', '😎', '🤔', '😢', '😡', '😍', '🥳', '🤯', '😴', '😬', '😈', '🙈', '✊', '👀', '🐍', '😳',
        //bread emoji
        '🍞', '😵‍💫', '😊', '😟', '😠', '🤬', '😭', '💩', '🫶', '🍆', '🚢', '🥇', '🤪', '🤑', '🫠', '🤖', '🤓', '👻', '🌈', '🤨', '💅', '💀', '🥀','🤣',
        '👴','🆘','🥖',
        '💪','💦'
    ];
    emojiList.forEach((emojiChar) => {
        const emoji = new DemoEngine.Image();
        emoji.loadCustomSync(emojiChar, renderCharacterToCanvas);
    });
  })();

  this.setScene('emojis');

  this.loader.addAnimation({
    "light": {
        "type": "Ambient",
        "properties": { "intensity": 2.0 },
        "castShadow": false
    }
    ,"color": [{
        "r": 0.8, "g": 0.8, "b": 0.8
    }]
  });

    this.loader.addAnimation({
      "light": {
          "type": "Directional",
          "properties": { "intensity": 1.5 },
          "castShadow": true
      }
      ,position:[{x:0.5,y:3,z:2}]
    });    

    const particleCount = 200;
  const emojiList = [
  '😂',
  ];

  emojiList.forEach((emoji) => {
    let particles = new Array(particleCount);
    for (let i = 0; i < particleCount; i++) {
      // circle around center
      const startPercent = Utils.random();
      const startPercent2 = Utils.random();
      const startPercent3 = Utils.random();
      const startRadius = 1.5 + startPercent3 * 2.0;
      particles[i] = {
        x: 0,
        y: 0,
        z: -1,
        scale: 0.2,
        startPercent: startPercent,
        startPercent2: startPercent2,
        startPercent3: startPercent3,
        startRadius: startRadius
      };
    }
    this.loader.addAnimation({
      image: emoji,
      position: [
        {
          x: 0,
          y: -1,
          z: 0
        }
      ],
      /*angle:[{             
          degreesY:()=>getSceneTimeFromStart()*60,              
        }],*/
      /*angle: [{
        degreesY: ()=> getSceneTimeFromStart() * 60,
        degreesX: ()=> getSceneTimeFromStart() * 60
     }],*/
      scale: [{ uniform3d: 1.0 }],
      "perspective": "3d",
      "billboard": true,
      "additive": true,
      /*"material":{
        "blending": 'AdditiveBlending',
        "transparent":true,
        "depthWrite":false,
      },*/
      color: [{r:1,g:1,b:1}],
      //"scale":[{"uniform3d":.1}],
      "instancer": {
        "count": particleCount,
        "runInstanceFunction": (properties) => {

          const i = properties.index;
          const count = properties.count;
          const time = properties.time;
          let object = properties.object;
          let color = properties.color;

          const particle = particles[i]; 
          const countPercent = (i/count > Sync.get('Emojis:countPercent', -1.0) ? 0 : 1);
          if (countPercent <= 0) {
            color.a = 0.0;
            return;
          }

          const w = Sync.get('AspectRatio:width');
          const h = Sync.get('AspectRatio:height');
          const aspectRatio = w/h;

          const circle = () => {
            const percent = (time*0.1+particle.startPercent) % 1.0;
            const angle = percent * Math.PI * 2;            
            const x = Math.cos(angle) * particle.startRadius * aspectRatio;
            const y = Math.sin(angle) * particle.startRadius + 1.0;
            const z = particle.z;
            let scale = particle.scale + particle.startRadius/5.0;// * Math.min(time * 0.1, 1.0);

            return [x, y, z, scale];
          };

          const disc = () => {
            const percent = (time*0.1+particle.startPercent) % 1.0;
            const angle = percent * Math.PI * 2;
            const x = Math.cos(angle) * particle.startRadius * aspectRatio;
            const y = Math.sin(angle) * particle.startRadius;
            const z = Math.cos(angle) * particle.startRadius;
            let scale = particle.scale + particle.startRadius/5.0;// * Math.min(time * 0.1, 1.0);

            return [x, y, z, scale];
          };

          const vortex = () => {
            const percent = (time*0.1+particle.startPercent) % 1.0;
            const percent2 = (time*0.1+particle.startPercent2) % 1.0;
            const theta = percent * Math.PI * 2;
            const phi = percent2 * Math.PI;
            const radius = 6.0;
            const r = radius/2 + radius/2*particle.startPercent3;

            const x = r * Math.sin(phi) * Math.cos(theta) * aspectRatio;
            const y = r * Math.sin(phi) * Math.sin(theta) + 0.5;
            const z = r * Math.cos(phi) + 1;
            let scale = particle.scale + particle.startRadius/5.0;// * Math.min(time * 0.1, 1.0);

            return [x, y, z, scale];
          };

          const sphere = () => {
            const percent = (time*0.0+particle.startPercent) % 1.0;
            const percent2 = (time*0.0+particle.startPercent2) % 1.0;
            const theta = percent * Math.PI * 2;
            const phi = percent2 * Math.PI;
            const radius = 10.0;
            const r = radius/2 + radius/2;

            const x = r * Math.sin(phi) * Math.cos(theta) * aspectRatio;
            const y = r * Math.sin(phi) * Math.sin(theta) + 0.5;
            const z = r * Math.cos(phi);
            let scale = 2.0;// * Math.min(time * 0.1, 1.0);

            return [x, y, z, scale];
          };

          let shapes = [circle, disc, vortex, sphere];

          const [x, y, z, scale] = shapes[Sync.get('Emojis:Shape', 0)]();


          object.position.x = x;
          object.position.y = y;
          object.position.z = z;


            color.r = Sync.get('Emojis:r', 1);
            color.g = Sync.get('Emojis:g', 1);
            color.b = Sync.get('Emojis:b', 1);
            color.a = Sync.get('Emojis:a', 1) * countPercent;
            /*color.a = Math.max(Math.sin(time*18.0), 0.0);
            const percent = time/6.0;
            if (i > particleCount*percent) {
              color.a = 0.0;
            }*/

          //}

          object.scale.x = scale;
          object.scale.y = scale;
          object.scale.z = scale;
        }
      }
    });
  });



  //};


};
