Demo.prototype.sceneBackrooms = function () {
    this.setScene('backrooms');
    this.cameraSetup();


    const gridSeparation = 5.0; 
    const gridY = 0; 


    const gridSize = 4;
    const half = (gridSize - 1) / 2;
    for (let ix = 0; ix < gridSize; ix++) {
        for (let iz = 0; iz < gridSize; iz++) {
            const x = (ix - half) * gridSeparation;
            const z = (iz - half) * gridSeparation;

            const isInner = (ix === 1 || ix === 2) && (iz === 1 || iz === 2);
            this.loader.addAnimation({
                light: {
                    type: "Point",
                    properties: { intensity: isInner ? 3.8 : 2.5, decay: isInner ? 2.0 : 1.2 },
                },
                position: [{ x, y: gridY, z }]
            });
        }
    }

    this.loader.addAnimation({
        object: 'obj/backroms.obj',
        perspective: '3d',
        scale: [{ uniform3d: 1.0 }],
        position: [{ x: 0, y: 0.5, z: 0 }],
        color: [{
            r: 1.1,
            g: 1.1,
            b: 1.0,
            a: 1.0
        }]
    });

    this.loader.addAnimation({
        object: 'obj/farjan.obj',
        perspective: '3d',
        scale: [{ x: () => 1.0 + Math.random() * Sync.get('Farjan:Scale'), y: () => 1.0 + Math.random() * Sync.get('Farjan:Scale'), z: () => 1.0 + Math.random() * Sync.get('Farjan:Scale') }],
        position: [{ x: ()=>Sync.get('Farjan:PositionX'), y: ()=>Sync.get('Farjan:PositionY'), z: ()=>Sync.get('Farjan:PositionZ') }],
        angle: [{
            degreesY: () => Sync.get('Farjan:RotationY'),degreesX: () => Sync.get('Farjan:RotationX'),degreesZ: () => Sync.get('Farjan:RotationZ')
        }],
    });   
    
    
        this.textWriter("Wait for until end ... ", {
            fontId: 0,
            y: -.37,
            x: -0.1,
            fontScale: 0.27,
            bgScaleY: 0,            
            outline: true
        });

    for (let i = 0; i < 2; i++) {
        this.addAnimationToMainScene({
            image: '👀',  // The emoji character itself
            perspective: '2d',
            position: [{ x: 0.075, y: -0.41, z: 0 }],
            scale: [{ uniform2d: 0.3 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });

    }       
};
