
Demo.prototype.sceneAmigaBall = function () {
    this.setScene('amigaBall');


    this.loader.addAnimation({
        image: 'images/amigabg.png',
        perspective: '2d',
        position: [{ x: () => .01 * Math.sin(getSceneTimeFromStart()*2), y: () => .01 * Math.cos(getSceneTimeFromStart()), z: -1 }],
        scale: [{ uniform2d: 1.0 }],
        color: [{
            r: 0.68,
            g: 0.68,
            b: 0.68
        }]
    });

    this.loader.addAnimation({
        light: {
            type: "Directional",
            properties: { intensity: 2.0 },
            castShadow: true
        },
        position: [{ x: 2, y: 3, z: 2 }]
    });

    this.loader.addAnimation({
        id: "ballRootRoot",
        object: null,
        perspective: '3d',
        position: [{
            x: 0,
            y: 0,
            z: 0
        }],
        scale: [{
            x: () => .9 + Math.sin(getSceneTimeFromStart() * 6) * -0.15,
            y: () => .9 + Math.sin(getSceneTimeFromStart() * 6) * 0.3,
            z: () => .9 + Math.sin(getSceneTimeFromStart() * 6) * -0.15
        }],
    });

    this.loader.addAnimation({
        id: "ballRoot",
        parent: "ballRootRoot",
        object: null,
        perspective: '3d',
        position: [{
            x: () => Math.sin(getSceneTimeFromStart() * (6 * .25)) * 1,
            y: () => Math.sin(1 + getSceneTimeFromStart() * 6) * 0.6,
            z: 0
        }],
        angle: [{
            degreesZ: -35,
        }]
    });
    // Add the rotating Amiga ball
    this.loader.addAnimation({
        parent: "ballRoot",
        object: 'obj/amigaball.obj',
        perspective: '3d',

        angle: [{
            degreesY: () => getSceneTimeFromStart() * 160,
        }],
        scale: [{ uniform3d: 0.5 }],
        color: [{
            r: 1.0,
            g: 1.0,
            b: 1.0,
            a: 1.0
        }]
    });

    this.textWriter("Boomers love TS", {
        fontId: 0,
        y: .1,
        x: 0,
        fontScale: 0.3,
        bgScaleY: 0,
        outline: true
    });

    for (let i = 0; i < 2; i++) {
        this.loader.addAnimation({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: 0.0, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
        this.loader.addAnimation({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: 0.05, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
        this.loader.addAnimation({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: -0.05, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
    }

    this.loader.addAnimation({
        image: 'sceneAmigaBall/jml_logo_mtv.png',
        position:[{x:0.2, y:0.4}],
        scale:[{uniform2d:0.5}],
        color:[{a:0.16}]
    });

        // amiga ball
            this.textWriter("Boomers love TS", {
        fontId: 0,
        y: .1,
        x: 0,
        fontScale: 0.3,
        bgScaleY: 0,
        outline: true,
    });

    for (let i = 0; i < 2; i++) {
        this.addAnimationToMainScene({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: 0.0, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
        this.addAnimationToMainScene({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: 0.05, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
        this.addAnimationToMainScene({
            image: '🤣',  // The emoji character itself
            perspective: '2d',
            position: [{ x: -0.05, y: 0.025, z: 0 }],
            scale: [{ uniform2d: 0.35 - (i * .0125) }],
            color: [{
                r: i,
                g: i,
                b: i
            }]
        });
    }
};
