
Demo.prototype.sceneAlarm = function () {
  this.setScene('alarm');

  this.loader.addAnimation({
    "light": {
      "type": "Ambient",
      "properties": { "intensity": 2.0 },
      "castShadow": false
    }
    , "color": [{
      "r": 1.0, "g": 1.0, "b": 1.0
    }]
  });

  this.loader.addAnimation({
    "light": {
      "type": "Directional",
      "properties": { "intensity": 1.5 },
      "castShadow": false
    }
    , position: [{ x: 0.5, y: 3, z: 2 }]
  });

  const barZ = -2;
  const barHeight = 10;
  const barWidth = 120;
  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar0',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },

      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())), g: 0.0, b: 1.0 }]
    }
  ]);

  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar1',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },
      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(.75 + 2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: 0.0, g: 1.0, b: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())) }]
    }
  ]);

  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar2',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },
      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(1.5 + 2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: 1.0, g: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())), b: 0.0 }]
    }
  ]);

  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar3',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },
      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(2.25 + 2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())), g: 1.0, b: 0.0 }]
    }
  ]);

  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar4',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },
      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(3 + 2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: 1.0, g: 0.0, b: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())) }]
    }
  ]);

  this.loader.addAnimation([
    {
      object: 'sceneAlarm/bar.png',
      id: 'bar5',
      shape: {
        type: 'PLANE',
        width: 0.1,
        height: 0.1,
      },
      perspective: '3d',
      position: [
        {
          x: 0,
          y: () => .1 + .8 * Math.sin(3.75 + 2 * getSceneTimeFromStart()),
          z: barZ
        }
      ],
      scale: [{ x: barWidth, y: barHeight }],
      color: [{ r: 0.0, g: () => Math.abs(Math.sin(5 * getSceneTimeFromStart())), b: 1.0 }]
    }
  ]);

  this.loader.addAnimation([
    {
      start: 4,
      object: 'sceneAlarm/suspect.png',
      parent: 'bar3',
      shape: {
        type: 'PLANE',
        width: 0.5,
        height: 0.4,
      },
      scale: [{ x: 1 / barWidth, y: 1 / barHeight }],
      position: [{ y: 0.06, x: 0.06 }, { duration: 2, x: -0.06 }],
      color: [{ r: 0.0, g: 0.0, b: 1.0 }],
      perspective: '3d',
    }
  ]);

  this.loader.addAnimation([
    {
      start: 6,
      object: 'sceneAlarm/suspect.png',
      parent: 'bar2',
      shape: {
        type: 'PLANE',
        width: 0.5,
        height: 0.4,
      },
      scale: [{ x: 1 / barWidth, y: 1 / barHeight }],
      position: [{ y: 0.06, x: 0.06 }, { duration: 2, x: -0.06 }],
      color: [{ r: 0.0, g: 1.0, b: 0.0 }],
      perspective: '3d',
    }
  ]);

  this.loader.addAnimation([
    {
      start: 6.5,
      object: 'sceneAlarm/suspect.png',
      parent: 'bar5',
      shape: {
        type: 'PLANE',
        width: 0.5,
        height: 0.4,
      },
      scale: [{ x: -1 / barWidth, y: -1 / barHeight }],
      position: [{ y: -0.06, x: -0.06 }, { duration: 2, x: 0.06 }],
      color: [{ r: 1.0, g: 1.0, b: 0.0 }],
      perspective: '3d',
    }
  ]);

  this.loader.addAnimation([{
    text: {
      string: 'The DooM Crew is proud to PREZENT our first d3m0: The Cradle of Demonic Demons. Greetings fly out to Magnetismi Computer Crew, Jumalauta, and all the eliteZ in the DEM0SCENE!', name: "font/ComicSans.ttf"
    },
    perspective: "3d",
    color: [{ "r": () => .75 + .25 * Math.random(), "g": () => .75 + .25 * Math.random(), "b": () => .75 + .25 * Math.random() }],
    position: [{ x: () => 17 + -0.5 * (getSceneTimeFromStart() * 7 - 5) % 80, y: () => .1 + .7 * Math.sin(5.0 * getSceneTimeFromStart()), z: -1 }],
    scale: [{ uniform2d: 3.0 }],
  }]);

  const flickerFrequency = 12.0;
  const lightFlicker = () => (Math.sin(getSceneTimeFromStart() * flickerFrequency) + 1) / 2;

  const objStart = 0;
  const lightZ = 1.0;



  const text3d = function (loader, text, options) {
    const skew = Utils.random() * 5;
    const lightFlicker2 = () => (Math.sin(skew + getSceneTimeFromStart() * flickerFrequency) + 1) / 2 * 0.8;

    loader.addAnimation({
      start: options.start ?? 0,
      text: {
        string: text,
        name: [
          'font/TikTokSans-Bold.ttf',
          'font/TikTokSans-Light.ttf',
          'font/TikTokSans-Regular.ttf',
          'font/ComicSans.ttf'
        ][options.fontId ?? 0],
        parameters: { size: 5, depth: options.depth ?? 0.01, bevelEnabled: false }
      },
      perspective: "3d",
      position: [{ x: options.x ?? 0, y: options.y ?? 0, z: options.z ?? -2 }],
      scale: [{ uniform3d: options.fontScale ?? 1.0 }],
      color: [{ r: 1, g: lightFlicker2, b: lightFlicker2 }],
      angle: [{ degreesX: options.degreesX ?? 0, degreesY: options.degreesY ?? 0, degreesZ: options.degreesZ ?? 0 }]
    });
  };

  for (let i = 0; i < 40; i++) {
    let y = Utils.random() < 0.5 ? -1.5 - Utils.random() : 1.5 + Utils.random();

    text3d(this.loader, "SUS", {
      start: i * 0.3 + 3,
      fontId: Math.floor(Utils.random() * 3.9),
      fontScale: Utils.random() * 5 + 2,
      depth: Utils.random() * 1.0 + 0.01,
      y: y, x: Utils.random() * 8 - 4, z: Utils.random() * 3 - 3,
      degreesX: Utils.random() * 40 - 20, degreesY: Utils.random() * 40 - 20, degreesZ: Utils.random() * 40 - 20
    });
  };

  const raideDuration = 6;

  this.loader.addAnimation({
    start: objStart,
    object: 'sceneAlarm/siren-case.obj',
    id: 'siren',
    cubeMap: { name: 'cube1' },

    material: {
      envMap: 'cube1.cube.map',
      metalness: 0,
      roughness: 1,

    },
    angle: [{ degreesX: () => -90 }],
    color: [{ r: 1, g: 1, b: 1 }],
    position: [{ x: 0, y: -2.0, z: lightZ }, { duration: raideDuration, y: ()=> Math.sin(getSceneTimeFromStart())*.1-0.2 }],
    scale: [{ uniform3d: 5 }],
  });
  this.loader.addAnimation({
    start: objStart,
    object: 'sceneAlarm/siren-light.obj',
    parent: 'siren',
    id: 'sirenlight',
    material: {
      envMap: 'cube1.cube.map',
    },
    angle: [{ degreesY: () => getSceneTimeFromStart() * 150, degreesX: 90 }],
    color: [{ r: () => 1.0, g: lightFlicker, b: lightFlicker }],
    position: [{ x: 0, y: 0.0, z: 0 }],
    scale: [{ uniform3d: 3.1 }]
  });


  const spotIntensity = 30;
  const spotAngle = Math.PI / 14;
  this.loader.addAnimation({
    start: 4,
    parent: 'sirenlight',
    light: {
      type: 'Spot',
      properties: {
        intensity: spotIntensity,
        distance: 0,
        decay: 0,
        angle: spotAngle
      },
      castShadow: false,
    },
    color: [{ r: 1.0, g: 0, b: 0 }],
    //angle:[{degreesY:90}],
    position: [{ x: 0.0, y: -0.0, z: 1.0 }]
  });
  this.loader.addAnimation({
    start: 4,
    parent: 'sirenlight',
    light: {
      type: 'Spot',
      properties: {
        intensity: spotIntensity,
        distance: 0,
        decay: 0,
        angle: spotAngle
      },
      castShadow: false,
    },
    color: [{ r: 1.0, g: 0, b: 0 }],
    //angle:[{degreesY:90}],
    position: [{ x: 0.0, y: -0.0, z: -1.0 }]
  });

  this.loader.addAnimation({
    //object: 'sceneAlarm/siren-case.obj',
    start: objStart,
    visible: true,
    object: null,
    //parent:'siren',
    shape: {
      type: 'SPHERE',
    },
    material: {
      type: 'Physical',
      envMap: 'cube1.cube.map',
      transparent: true,
      castShadow: false,
      opacity: 0.2,
      metalness: 0,
      roughness: 0,

      /*type:'Physical',
  transmission: 1,
  opacity: 1,
  ior: 1.52,
  thickness: 0.1,
  specularIntensity: 1,
  specularColor: 0xffffff,
  lightIntensity: 1,
  exposure: 1,
*/
    },
    //angle:[{degreesX:90}],
    //color:[{a:0.8}],
    position: [{ x: 0, y: -2.0, z: lightZ }, { duration: raideDuration, y: ()=> Math.sin(getSceneTimeFromStart())*.1-0.2 }],
    scale: [{ x: 0.6, z: 0.6, y: 0.8 }],
    /*shader: {
      fragmentShaderSuffix:`gl_FragColor.a = 0.4;`
    },*/
  });


  this.textWriter("Uncs while watching vibed Atari demo", {
    fontId: 2,
    y: .36,
    x: 0,
    fontScale: 0.372,
    //bgScaleY: 0,
    outline: true
  });

  for (let i = 0; i < 2; i++) {
    this.addAnimationToMainScene({
      image: '👴',  // The emoji character itself
      perspective: '2d',
      position: [{ x: 0.0, y: 0.30, z: 0 }],
      scale: [{ uniform2d: 0.4 - (i * .0125) }],
      color: [{
        r: i,
        g: i,
        b: i
      }],
      angle: [{ degreesZ: () => getSceneTimeFromStart() * 400 }]
    });
    this.addAnimationToMainScene({
      image: '😭',  // The emoji character itself
      perspective: '2d',
      position: [{ x: 0.08, y: 0.30, z: 0 }],
      scale: [{ uniform2d: 0.4 - (i * .0125) }],
      color: [{
        r: i,
        g: i,
        b: i
      }]
    });
    this.addAnimationToMainScene({
      image: '😭',  // The emoji character itself
      perspective: '2d',
      position: [{ x: -0.08, y: 0.30, z: 0 }],
      scale: [{ uniform2d: 0.4 - (i * .0125) }],
      color: [{
        r: i,
        g: i,
        b: i
      }]
    });
  }

};
