in vec2 texCoord;
out vec4 fragColor;
uniform sampler2D texture0; // current frame
uniform sampler2D texture1; // previous frame (feedback buffer)
uniform vec4 color;
uniform float feedbackAmount; // how much of the previous frame to keep (0.0-1.0)
uniform float fadeAmount; // how much to fade the previous frame (0.0-1.0)

void main()
{
    vec4 currentFrame = texture(texture0, texCoord);
    vec4 previousFrame = texture(texture1, texCoord);
    
    // Fade the previous frame
    previousFrame *= fadeAmount;
    
    // Add current frame to faded previous frame (additive blend for trails)
    fragColor = currentFrame + previousFrame * feedbackAmount;
    fragColor.a = 1.0;
}
