in vec2 texCoord;
out vec4 fragColor;

#define M_PI 3.1415926535897932384626433832795

uniform vec4 color;
uniform float time;

uniform sampler2D texture0;

#define MAX_LIGHTS 24
uniform vec3 lightColor[MAX_LIGHTS];

vec2 pixelate(vec2 coord)
{
    vec2 d = vec2(1.0,1.0)/(vec2(1920.0,1080.0)*0.03);
    coord.s = floor(coord.s/d.s)*d.s;
    coord.t = floor(coord.t/d.t)*d.t;
    return coord;    
}


void main()
{
    vec2 position = vec2(-0.5, -0.5);
    vec4 backgroundColor = vec4(0.,0.,0.,0.);
    float maxLights = float(MAX_LIGHTS);
    float curveThickness = 1.0/maxLights;
    float curveBendDegrees = 0.;
    float curvesDegrees = 360.;
    float fadeStart = 0.2;
    float fadeEnd = 0.65;


    float time2 = time/60.0*120.0;
    if (mod(time2, 2.0) >= 1.0) {
        time2 = 0.0; 
    } else {
        time2 *= 0.24;
    }
    vec2 coord=texCoord.xy;
    vec2 screenCoords = coord;

    float fade = 1.0;
    fade = smoothstep(fadeStart, fadeEnd, distance(screenCoords,vec2(0.5, 0.5)));

    float x = coord.x;
    float y = coord.y;
    float d = sqrt(x*x + y*y);

    vec4 col = backgroundColor;
    {
        coord += position;
        float curveBendRad = radians(curveBendDegrees);
        float curvesRad = radians(curvesDegrees);
        float bend = curveBendRad*log(length(coord));
        
        for(float i = 0.0; i < maxLights; i++) {
            float light = i/maxLights;
            float d = mod(2.0*M_PI*light+atan(coord.x,coord.y)+bend, curvesRad);
            if (d < curvesRad*curveThickness)
            {
                float cx = position.x+x;
                float cy = position.y+y;
                float circle = 1.0/sqrt(cx*cx + cy*cy);

                int lightIndex = int(mod(i,maxLights));
                col = vec4(lightColor[lightIndex],fade*1.0);
            }
        }


    }
    if (col.r+col.g+col.b <= 0.0) {
        discard;
    }
    fragColor = vec4(col.r,col.g,col.b,col.a) * color;
}
