Demo.prototype.addEffectSkibidiStarfield = function (startTime, durationTime, amountOfParticles, texture, areaSizeX,areaSizeY,areaSizeZ, particleSize, parentId,x,y,z, speed = 1.0, directionFlip = 0.0, highlight = false)
{
  const recalcThreshold = 0.1;

  let stars = new Array(amountOfParticles);
  const sizeX = areaSizeX;
  const sizeY = areaSizeY;
  const sizeZ = areaSizeZ;
  for (let i = 0; i < stars.length; i++) {
    let z1 = Utils.random();
    stars[i] = {
      "x0": Utils.random()*sizeX*2-sizeX+x,
      "y0": Utils.random()*sizeY*2-sizeY+y,
      "x1": Utils.random()*sizeX*2-sizeX+x,
      "y1": Utils.random()*sizeY*2-sizeY+y,
      "z1": Utils.random()*sizeZ*2-sizeZ+z,
      "z2": z
    };
  }

  z = -50;
  this.loader.addAnimation({
    "start":startTime, "duration":durationTime,
    "image": texture,
    textureProperties: [{},{minFilter: 'NearestMipmapNearestFilter', magFilter: 'LinearFilter'}],
    "parent":parentId,
    "position":[{
      "x":0,
      "y":0,
      "z":-50,
    }],
    "angle":[{"degreesY":180}],
    "perspective": "3d",
    "billboard": true,
    "additive": true,
    "material":{
      "blending": 'AdditiveBlending',
      "transparent":true,
      "depthWrite":false,

    },
    "scale":[{"uniform3d":.1}],
    "instancer": {
      "count": stars.length,
      "runInstanceFunction": (properties) => {

        const i = properties.index;
        const count = properties.count;
        const time = properties.time;
        let object = properties.object;
        let color = properties.color;

        let scale = particleSize;

        let startPercent =1;

        color.a = 0.15;

        if (highlight) {
          color.r = 1.0;
          color.g = 0.0;
          color.b = 0.0;
          scale *= 1.3;
        }

        object.scale.x = scale;
        object.scale.y = scale;
        object.scale.z = scale;

          const bpm = 115;
          const beat = 60/bpm;

        const realSizeZ = 500;
        const percent = -(getSceneTimeFromStart())%(beat*2);
        stars[i].z2 = (percent*realSizeZ*2+stars[i].z1);
        if(stars[i].z2<-realSizeZ)
          stars[i].z2+=realSizeZ*2;

        object.position.z = stars[i].z2;
        object.position.x = stars[i].x1;
        object.position.y = stars[i].y1;
        if (highlight) {
          object.position.x += Math.sin(time*speed*1000.0)*1.0;
          object.position.y += Math.cos(time*speed*1000.0)*1.0;
        }

        }
      }
    
  });
};

Demo.prototype.sceneBackground1 = function () {
    this.setScene('background1');
    
    this.loader.addAnimation([
      {
        image: {
          name: 'background/twirlbg.png'
        },
        perspective: '2d',
        position: [
          {
            x: 0,
            y: 0,
            z: 0
          }
        ],  
        angle:[{                      
          degreesZ:()=>getSceneTimeFromStart()*116,      
        }],
        scale: [{ uniform2d: 8.3 }],
        color: [{
          r: 1, g: 1, b: 1, a:1.0
      }],
      shader: {
      name: 'background/colorcycle.fs',
      variable: [
        {"name":"centerize","value":[()=>0.0]},
        {"name":"shiftHue", "value":[()=>{
          const time = getSceneTimeFromStart();
          const bpm = 115;
          const changePerBeat = 1.0/8.0;
          const currentBeat = (time/60.0)*bpm;

          if (currentBeat % 4.0 < 2.0) {
            return (time/60.0)*bpm*changePerBeat % 1.0;
          } else {
            return 0.0;//1.0 + 0.5 * (1.0 - (currentBeat % 1.0)) * 2.0;
          }
      }]},
        {"name":"shiftSaturation", "value":[()=>1.0]},
        {"name":"shiftValue", "value":[()=>{

          const time = getSceneTimeFromStart();
          const bpm = 115;
          const currentBeat = (time/60.0)*bpm;
          if (currentBeat % 3.0 < 0.2) {
            return 1.0 + 0.5 * ((currentBeat % 1.0) / 0.2) * 0.5;
          } else {
            return 0.0;//1.0 + 0.5 * (1.0 - (currentBeat % 1.0)) * 2.0;
          }
      }]}
      ]
    }
      }
    ]);
  const emojiList = [
  '🚢', 
];
  for(let i = 0; i < emojiList.length; i++)
  {
    const emoji = emojiList[i];
    //this.addEffectStarfield(0,240, 10*i*3, emoji, 700,700,1000, 5.5, null, 0,0,0, 1.0, 0.0, false);
    this.addEffectSkibidiStarfield(0,2000, 20, emoji, 700,700,1000, 5.5, null, 0,0,0, 1.0, 0.0, false);
  }

}